/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.chart;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TableRectLineRightCategoryChart
extends AbstractChart {
    private float x;
    private float height = 120.0f;
    private float width = 450.0f;
    private float y;
    private float[] levels;
    private String[] itemNames;
    private String[] tagNames;
    private List<float[]> scores;
    private String[] gradeNames;
    private float gradeRectWidth = 50.0f;
    private float gradeRectHeight = 26.0f;
    private int[] gradeFillColor;
    private int tableBackColor = 0xDDDDDD;
    private float fontSize = 10.0f;
    private float positionY;
    private int levleLineColor = 0xDDDDDD;
    private int levleTextColor = 5146053;
    private int scoreLineColor = 0xDDDDDD;
    private int frameLineColor = 0xAAAAAA;
    private int fillRectColor = 14413556;
    private int rectSepLineColor = 10747911;
    private int scorePointColor = 5146053;
    private int rectLineColor = 5146053;
    private int maxScoreColNum = 2;
    private int minScoreColNum = 3;
    private int curScoreColNum = 0;
    private int[] showDataColInTables;

    public TableRectLineRightCategoryChart() {
    }

    public TableRectLineRightCategoryChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, this.scores) || this.scores.isEmpty()) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new float[]{0.8f, 0.9f, 1.0f, 1.1f, 1.2f};
        }
        if (ObjectUtils.equals(null, (Object)this.tagNames)) {
            this.tagNames = new String[]{"\u6307\u6807\u5f97\u5206", "\u5e73\u5747\u5206"};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeNames)) {
            this.gradeNames = new String[]{"\u4f18\u79c0", "\u826f\u597d", "\u5408\u683c", "\u5f85\u53d1\u5c55"};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeFillColor)) {
            this.gradeFillColor = new int[]{6149040, 9621584, 0xFFC000, 0x7F7F7F};
        }
        if (ObjectUtils.equals(null, (Object)this.showDataColInTables)) {
            this.showDataColInTables = new int[]{0, 1};
        }
        try {
            BaseColor frameLineColor_ = new BaseColor(this.frameLineColor);
            BaseColor levleTextColor_ = new BaseColor(this.levleTextColor);
            BaseColor leveLineColor_ = new BaseColor(this.levleLineColor);
            BaseColor scoreLineColor_ = new BaseColor(this.scoreLineColor);
            float cellHeight = 20.0f;
            this.contentByte.setLineWidth(1.0f);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.drawFrame(frameLineColor_, leveLineColor_, levleTextColor_);
            this.setLine(7, 11.55f, this.document);
            float rowHeight = this.drawTable(20.0f, leveLineColor_);
            this.drawScores(scoreLineColor_);
            this.drawGrade();
            this.drawTag(rowHeight, 20.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawGrade() {
        float levelHeight = this.height / (float)(this.levels.length - 1);
        float y0 = this.y;
        float x0 = this.x + 1.0f;
        BaseColor color = null;
        for (int i = this.gradeNames.length - 1; i >= 0; --i) {
            color = new BaseColor(this.gradeFillColor[i]);
            this.contentByte.setColorStroke(color);
            this.contentByte.setColorFill(color);
            this.contentByte.roundRectangle(x0, y0 + (levelHeight - this.gradeRectHeight) / 2.0f, this.gradeRectWidth, this.gradeRectHeight, 1.0f);
            this.contentByte.fillStroke();
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.contentByte.setColorFill(BaseColor.WHITE);
            this.drawMulRowText(this.gradeRectHeight, this.gradeRectWidth, this.gradeNames[i], x0, y0 + levelHeight - (levelHeight - this.gradeRectHeight) / 2.0f);
            y0 += levelHeight;
        }
    }

    private void drawFrame(BaseColor frameLineColor, BaseColor leveLineColor, BaseColor levleTextColor_) {
        float sepWidth = this.width / (float)this.itemNames.length - 1.0f;
        this.contentByte.setColorStroke(frameLineColor);
        this.moveLine(this.contentByte, this.x - 2.0f, this.y, this.x + this.width + sepWidth, this.y);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        float x1 = this.x;
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float kWidth = this.width / (float)this.itemNames.length;
        float y1 = 0.0f;
        for (int i = 0; i < this.levels.length; ++i) {
            y1 = this.y + kHeight * (this.levels[i] - this.levels[0]);
            this.contentByte.setColorStroke(frameLineColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x1, y1, this.x - 2.0f, y1);
            this.contentByte.setColorFill(levleTextColor_);
            this.moveText(this.contentByte, this.levels[i] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
            if (i <= 0) continue;
            this.contentByte.setColorStroke(leveLineColor);
            this.contentByte.setLineDash(1.0f, 2.0f, 0.0f);
            this.moveLine(this.contentByte, x1, y1, x1 + this.width + sepWidth, y1);
        }
        this.moveText(this.contentByte, this.levels[this.levels.length - 1] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
        this.contentByte.setColorStroke(frameLineColor);
        float x2 = this.x + sepWidth;
        float y2 = this.y;
        for (int i = 0; i < this.itemNames.length; ++i) {
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x2 += kWidth, y2, x2, y2 + 2.0f);
        }
    }

    private float drawTable(float cellHeight, BaseColor leveLineColor_) throws Exception {
        float sepWidth = this.width / (float)this.itemNames.length - 1.0f;
        float y0 = this.y - 2.0f;
        float x0 = this.x + sepWidth;
        float rowHeight = this.getRealRowHeight(sepWidth, cellHeight);
        for (int i = 0; i < this.itemNames.length; ++i) {
            this.moveRect(this.contentByte, x0, y0 - rowHeight, x0 + sepWidth, y0, this.tableBackColor, new boolean[0]);
            this.contentByte.setColorFill(BaseColor.BLACK);
            this.drawMulRowText(rowHeight, sepWidth, this.itemNames[i], x0 + 0.1f, y0);
            this.drawMulRowText(rowHeight, sepWidth, this.itemNames[i], x0 - 0.1f, y0);
            this.drawMulRowText(rowHeight, sepWidth, this.itemNames[i], x0, y0 - 0.1f);
            this.drawMulRowText(rowHeight, sepWidth, this.itemNames[i], x0, y0 + 0.1f);
            x0 += sepWidth + 1.0f;
        }
        y0 -= rowHeight + 1.0f;
        x0 = this.x + sepWidth;
        float[] rowScores = null;
        for (int j = 0; j < this.scores.size(); ++j) {
            if (ArrayUtils.contains((int[])this.showDataColInTables, (int)j)) {
                rowScores = this.scores.get(j);
                for (int k = 0; k < rowScores.length; ++k) {
                    this.moveRect(this.contentByte, x0, y0 - cellHeight, x0 + sepWidth, y0, this.tableBackColor, new boolean[0]);
                    this.drawMulRowText(cellHeight, sepWidth, rowScores[k] + "", x0, y0);
                    x0 += sepWidth + 1.0f;
                }
            }
            y0 -= cellHeight + 1.0f;
            x0 = this.x + sepWidth;
        }
        return rowHeight;
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
    }

    private float getRealRowHeight(float width, float cellHeight) {
        float rowHeight = 0.0f;
        float lineNumbers = 0.0f;
        for (int i = 0; i < this.itemNames.length; ++i) {
            lineNumbers = (float)this.itemNames[i].length() * this.fontSize / width;
            lineNumbers = lineNumbers > 1.0f ? (float)Math.ceil(lineNumbers) : 1.0f;
            rowHeight = lineNumbers * cellHeight;
        }
        return rowHeight;
    }

    private void drawScores(BaseColor scoreLineColor_) {
        float downScore = this.levels[0];
        float subScore = this.levels[this.levels.length - 1] - this.levels[0];
        float sepWidth = this.width / (float)this.itemNames.length - 1.0f;
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        float[] aStr = this.scores.get(this.curScoreColNum);
        float[] max = this.scores.get(this.maxScoreColNum);
        float[] min = this.scores.get(this.minScoreColNum);
        float maxScore = 0.0f;
        float minScore = 0.0f;
        BaseColor rectSepLineColor_ = new BaseColor(this.rectSepLineColor);
        BaseColor scorePointColor_ = new BaseColor(this.scorePointColor);
        BaseColor rectLineColor_ = new BaseColor(this.rectLineColor);
        float x1 = this.x + sepWidth;
        float x2 = this.x + sepWidth;
        float y3 = this.y + 1.0f;
        float y2 = this.y - 1.0f;
        for (int j = 0; j < aStr.length; ++j) {
            x1 += this.width / (float)this.itemNames.length;
            float scores = aStr[j] - downScore;
            float y1 = y3 + scores * this.height / subScore;
            this.contentByte.setLineWidth(0.3f);
            maxScore = max[j] - downScore;
            minScore = min[j] - downScore;
            int num = this.itemNames.length;
            this.moveRect(this.contentByte, x1 - this.width / (float)(2 * num) - 5.0f, y3 + maxScore * this.height / subScore, x1 - this.width / (float)(2 * num) + 10.0f, y3 + minScore * this.height / subScore, this.fillRectColor, new boolean[0]);
            this.contentByte.setColorStroke(rectLineColor_);
            this.moveLine(this.contentByte, x1 - this.width / (float)(2 * num) - 5.0f, y3 + maxScore * this.height / subScore, x1 - this.width / (float)(2 * num) + 10.0f, y3 + maxScore * this.height / subScore);
            this.moveLine(this.contentByte, x1 - this.width / (float)(2 * num) - 5.0f, y3 + minScore * this.height / subScore, x1 - this.width / (float)(2 * num) + 10.0f, y3 + minScore * this.height / subScore);
            this.moveLine(this.contentByte, x1 - this.width / (float)(2 * num) - 5.0f, y3 + maxScore * this.height / subScore, x1 - this.width / (float)(2 * num) - 5.0f, y3 + minScore * this.height / subScore);
            this.moveLine(this.contentByte, x1 - this.width / (float)(2 * num) + 10.0f, y3 + maxScore * this.height / subScore, x1 - this.width / (float)(2 * num) + 10.0f, y3 + minScore * this.height / subScore);
            this.contentByte.setColorStroke(rectSepLineColor_);
            this.contentByte.setLineWidth(0.7f);
            this.moveLine(this.contentByte, x1 - this.width / (float)(2 * num) - 5.0f, y3 + (maxScore + minScore) / 2.0f * this.height / subScore, x1 - this.width / (float)(2 * num) + 10.0f, y3 + (maxScore + minScore) / 2.0f * this.height / subScore);
            this.contentByte.setColorStroke(rectLineColor_);
            this.contentByte.setColorFill(scorePointColor_);
            if (j == 0) {
                x2 = x1;
                y2 = y1;
            } else {
                this.moveLine(this.contentByte, x1 - this.width / (float)(2 * num), y1, x2 - this.width / (float)(2 * num), y2);
                x2 = x1;
                y2 = y1;
            }
            this.moveText(this.contentByte, "\u25cf", x1 - this.width / (float)(2 * num) + 5.0f, (float)((double)y1 - 2.5), 2, 0.0f);
            this.contentByte.setColorStroke(scoreLineColor_);
            this.contentByte.setLineWidth(1.0f);
            this.moveLine(this.contentByte, x1 - this.width / (float)(2 * num) + 1.5f, y1, x1 - this.width / (float)(2 * num) + 1.5f, y3);
        }
    }

    private void drawTag(float rowHeight, float cellHeight) {
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        this.contentByte.setColorFill(BaseColor.BLACK);
        float sepWidth = this.width / (float)this.itemNames.length - 1.0f;
        float y1 = this.y - rowHeight - 3.0f;
        float x1 = this.x;
        this.positionY = rowHeight;
        for (int i = 0; i < this.tagNames.length; ++i) {
            this.moveRect(this.contentByte, this.x + sepWidth - 1.0f, y1, this.x, y1 - cellHeight, this.tableBackColor, new boolean[0]);
            this.drawMulRowText(cellHeight, sepWidth, this.tagNames[i], x1, y1);
            y1 -= cellHeight + 1.0f;
            this.positionY += cellHeight;
        }
    }

    public TableRectLineRightCategoryChart setX(float x) {
        this.x = x;
        return this;
    }

    public TableRectLineRightCategoryChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public TableRectLineRightCategoryChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableRectLineRightCategoryChart setY(float y) {
        this.y = y;
        return this;
    }

    public TableRectLineRightCategoryChart setLevels(float[] levels) {
        this.levels = levels;
        return this;
    }

    public TableRectLineRightCategoryChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public TableRectLineRightCategoryChart setTagNames(String[] tagNames) {
        this.tagNames = tagNames;
        return this;
    }

    public TableRectLineRightCategoryChart setScores(List<float[]> scores) {
        this.scores = scores;
        return this;
    }

    public TableRectLineRightCategoryChart setGradeNames(String[] gradeNames) {
        this.gradeNames = gradeNames;
        return this;
    }

    public TableRectLineRightCategoryChart setLevleLineColor(int levleLineColor) {
        this.levleLineColor = levleLineColor;
        return this;
    }

    public TableRectLineRightCategoryChart setFillRectColor(int fillRectColor) {
        this.fillRectColor = fillRectColor;
        return this;
    }

    public TableRectLineRightCategoryChart setGradeFillColor(int[] gradeFillColor) {
        this.gradeFillColor = gradeFillColor;
        return this;
    }

    public TableRectLineRightCategoryChart setScoreLineColor(int scoreLineColor) {
        this.scoreLineColor = scoreLineColor;
        return this;
    }

    public TableRectLineRightCategoryChart setFrameLineColor(int frameLineColor) {
        this.frameLineColor = frameLineColor;
        return this;
    }

    public TableRectLineRightCategoryChart setLevleTextColor(int levleTextColor) {
        this.levleTextColor = levleTextColor;
        return this;
    }

    public TableRectLineRightCategoryChart setRectSepLineColor(int rectSepLineColor) {
        this.rectSepLineColor = rectSepLineColor;
        return this;
    }

    public TableRectLineRightCategoryChart setScorePointColor(int scorePointColor) {
        this.scorePointColor = scorePointColor;
        return this;
    }

    public TableRectLineRightCategoryChart setRectLineColor(int rectLineColor) {
        this.rectLineColor = rectLineColor;
        return this;
    }

    public TableRectLineRightCategoryChart setMaxScoreColNum(int maxScoreColNum) {
        this.maxScoreColNum = maxScoreColNum;
        return this;
    }

    public TableRectLineRightCategoryChart setMinScoreColNum(int minScoreColNum) {
        this.minScoreColNum = minScoreColNum;
        return this;
    }

    public TableRectLineRightCategoryChart setCurScoreColNum(int curScoreColNum) {
        this.curScoreColNum = curScoreColNum;
        return this;
    }

    public TableRectLineRightCategoryChart setTableBackColor(int tableBackColor) {
        this.tableBackColor = tableBackColor;
        return this;
    }

    public TableRectLineRightCategoryChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableRectLineRightCategoryChart setGradeRectWidth(float gradeRectWidth) {
        this.gradeRectWidth = gradeRectWidth;
        return this;
    }

    public TableRectLineRightCategoryChart setGradeRectHeight(float gradeRectHeight) {
        this.gradeRectHeight = gradeRectHeight;
        return this;
    }

    public TableRectLineRightCategoryChart setShowDataColInTables(int[] showDataColInTables) {
        this.showDataColInTables = showDataColInTables;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY - 10.0f;
        return this.positionY;
    }
}

