/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.nbmf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.TPoint;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class CircleSeparateFixedSectorsChart
extends AbstractChart {
    private float x;
    private float sectorWidth = 30.0f;
    private float r = 80.0f;
    private float y;
    private float rotation = 253.0f;
    private String scoreSuffix = "\u5206";
    private float[] scores;
    private int[] fillColors;
    private String totalScoreName = "\u603b\u5206";
    private float totalScore;
    private int totalScoreNameColor = 93348;
    private int totalScoreColor = 0;
    private float totalScoreColorFontSize = 10.0f;
    private float fontSize = 8.0f;
    private int fontColor = 0xFFFFFF;
    private boolean showPoint = false;
    private float pointWidth = 5.0f;
    private float pointHeight = 5.0f;
    private float positionY;
    private final int SIDE_NUM = 3600;
    private final float MAX = 180.0f;
    private BaseColor[] fillColors_;
    private BaseColor fontColor_;

    public CircleSeparateFixedSectorsChart() {
    }

    public CircleSeparateFixedSectorsChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bscores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.fillColors)) {
            this.fillColors = new int[]{0xD9D9D9, 93348, 0xBFBFBF, 93348};
        }
        this.fontColor_ = new BaseColor(this.fontColor);
        this.fillColors_ = new BaseColor[this.fillColors.length];
        for (int i = 0; i < this.fillColors.length; ++i) {
            this.fillColors_[i] = new BaseColor(this.fillColors[i]);
        }
        float sum = 0.0f;
        for (float f : this.scores) {
            sum += f;
        }
        try {
            this.contentByte.setLineWidth(1.0f);
            this.contentByte.setColorFill(this.fontColor_);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.drawOneFillCircle(this.r, this.fillColors_, sum);
            this.contentByte.setColorStroke(BaseColor.WHITE);
            this.moveCircle(this.contentByte, this.x, this.y, this.r - this.sectorWidth, true);
            if (this.showPoint) {
                this.drawPoint(this.fillColors_, sum);
            }
            this.contentByte.setFontAndSize(this.baseFont, this.totalScoreColorFontSize);
            this.contentByte.setColorFill(new BaseColor(this.totalScoreNameColor));
            this.moveText(this.contentByte, this.totalScoreName, this.x, this.y + this.totalScoreColorFontSize / 2.0f, 1, 0.0f);
            this.contentByte.setColorFill(new BaseColor(this.totalScoreColor));
            this.moveText(this.contentByte, this.totalScore + this.scoreSuffix, this.x, this.y - this.totalScoreColorFontSize / 2.0f, 1, 0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawPoint(BaseColor[] fillColors, float sum) {
        this.getClass();
        float space = 360.0f / 3600.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        TPoint top = new TPoint();
        int num = this.scores.length;
        this.getClass();
        float everyErea = 3600.0f * this.scores[0] / sum;
        space = everyErea * space / 2.0f;
        for (int i = 0; i < num; ++i) {
            this.contentByte.setColorStroke(fillColors[i]);
            double d = this.r - this.sectorWidth - this.pointHeight;
            double d2 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            top.setX(this.x + (float)(d * Math.sin(d2 / 180.0)));
            double d3 = this.r - this.sectorWidth - this.pointHeight;
            double d4 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            top.setY(this.y + (float)(d3 * Math.cos(d4 / 180.0)));
            float f = 0.0f;
            while (f <= this.pointWidth * 2.0f) {
                double d5 = this.r - this.sectorWidth * 9.0f / 10.0f;
                double d6 = Math.PI * (double)(space - this.pointWidth + f + this.rotation);
                this.getClass();
                x0 = this.x + (float)(d5 * Math.sin(d6 / 180.0));
                double d7 = this.r - this.sectorWidth * 9.0f / 10.0f;
                double d8 = Math.PI * (double)(space - this.pointWidth + f + this.rotation);
                this.getClass();
                y0 = this.y + (float)(d7 * Math.cos(d8 / 180.0));
                this.moveLine(this.contentByte, top.getX(), top.getY(), x0, y0);
                f = (float)((double)f + 0.1);
            }
            this.getClass();
            everyErea = 3600.0f * this.scores[i] / sum;
            space += everyErea / 2.0f;
        }
    }

    private void drawOneFillCircle(float curR, BaseColor[] fillColors, float sum) {
        float space;
        this.getClass();
        float spaceSize = space = 360.0f / 3600.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        int num = this.scores.length;
        float[] everyEreas = new float[num];
        for (int i = 0; i < num; ++i) {
            this.getClass();
            everyEreas[i] = 3600.0f * this.scores[i] / sum;
        }
        int areaNum = 0;
        float areaSum = everyEreas[areaNum];
        for (int i = 0; i < this.SIDE_NUM; ++i) {
            if ((float)i <= areaSum) {
                this.contentByte.setColorStroke(fillColors[areaNum]);
            } else {
                areaSum += everyEreas[++areaNum];
            }
            double d = curR;
            double d2 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            x0 = this.x + (float)(d * Math.sin(d2 / 180.0));
            double d3 = curR;
            double d4 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            y0 = this.y + (float)(d3 * Math.cos(d4 / 180.0));
            this.moveLine(this.contentByte, this.x, this.y, x0, y0);
            space += spaceSize;
        }
    }

    public CircleSeparateFixedSectorsChart setX(float x) {
        this.x = x;
        return this;
    }

    public CircleSeparateFixedSectorsChart setSectorWidth(float sectorWidth) {
        this.sectorWidth = sectorWidth;
        return this;
    }

    public CircleSeparateFixedSectorsChart setR(float r) {
        this.r = r;
        return this;
    }

    public CircleSeparateFixedSectorsChart setScoreSuffix(String scoreSuffix) {
        this.scoreSuffix = scoreSuffix;
        return this;
    }

    public CircleSeparateFixedSectorsChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public CircleSeparateFixedSectorsChart setTotalScoreName(String totalScoreName) {
        this.totalScoreName = totalScoreName;
        return this;
    }

    public CircleSeparateFixedSectorsChart setTotalScore(float totalScore) {
        this.totalScore = totalScore;
        return this;
    }

    public CircleSeparateFixedSectorsChart setShowPoint(boolean showPoint) {
        this.showPoint = showPoint;
        return this;
    }

    public CircleSeparateFixedSectorsChart setY(float y) {
        this.y = y;
        return this;
    }

    public CircleSeparateFixedSectorsChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.r - 5.0f;
        return this.positionY;
    }

    public CircleSeparateFixedSectorsChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public CircleSeparateFixedSectorsChart setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public CircleSeparateFixedSectorsChart setFillColors(int[] fillColors) {
        this.fillColors = fillColors;
        return this;
    }

    public CircleSeparateFixedSectorsChart setTotalScoreNameColor(int totalScoreNameColor) {
        this.totalScoreNameColor = totalScoreNameColor;
        return this;
    }

    public CircleSeparateFixedSectorsChart setTotalScoreColor(int totalScoreColor) {
        this.totalScoreColor = totalScoreColor;
        return this;
    }

    public CircleSeparateFixedSectorsChart setTotalScoreColorFontSize(float totalScoreColorFontSize) {
        this.totalScoreColorFontSize = totalScoreColorFontSize;
        return this;
    }

    public CircleSeparateFixedSectorsChart setPointWidth(float pointWidth) {
        this.pointWidth = pointWidth;
        return this;
    }

    public CircleSeparateFixedSectorsChart setPointHeight(float pointHeight) {
        this.pointHeight = pointHeight;
        return this;
    }
}

