/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.nbmf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.TPoint;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class CircleSeparateManySectorsChart
extends AbstractChart {
    private float x;
    private float sectorWidth = 30.0f;
    private float r = 80.0f;
    private float y;
    private float rotation = 45.0f;
    private String[] itemNames;
    private String scoreSuffix = "\u5206";
    private float[] scores;
    private int[] fillColors;
    private String totalScoreName = "\u603b\u5206";
    private float totalScore;
    private int totalScoreNameColor = 93348;
    private int totalScoreColor = 0;
    private float totalScoreColorFontSize = 10.0f;
    private float fontSize = 8.0f;
    private int fontColor = 0xFFFFFF;
    private boolean showPoint = true;
    private float pointWidth = 5.0f;
    private float pointHeight = 5.0f;
    private float positionY;
    private final int SIDE_NUM = 3600;
    private final float MAX = 180.0f;
    private BaseColor[] fillColors_;
    private BaseColor fontColor_;

    public CircleSeparateManySectorsChart() {
    }

    public CircleSeparateManySectorsChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.itemNames) || this.itemNames.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bitemNames\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.fillColors)) {
            this.fillColors = new int[]{1611709, 2998229, 0xBFBFBF, 93348};
        }
        this.fontColor_ = new BaseColor(this.fontColor);
        this.fillColors_ = new BaseColor[this.fillColors.length];
        for (int i = 0; i < this.fillColors.length; ++i) {
            this.fillColors_[i] = new BaseColor(this.fillColors[i]);
        }
        try {
            this.contentByte.setLineWidth(1.0f);
            this.contentByte.setColorFill(this.fontColor_);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            this.drawOneFillCircle(this.r, this.fillColors_);
            this.contentByte.setColorStroke(BaseColor.WHITE);
            this.moveCircle(this.contentByte, this.x, this.y, this.r - this.sectorWidth, true);
            if (this.showPoint) {
                this.drawPoint(this.fillColors_);
            }
            this.drawItemNameAndScore();
            this.contentByte.setFontAndSize(this.baseFont, this.totalScoreColorFontSize);
            this.contentByte.setColorFill(new BaseColor(this.totalScoreNameColor));
            this.moveText(this.contentByte, this.totalScoreName, this.x, this.y + this.totalScoreColorFontSize / 2.0f, 1, 0.0f);
            this.contentByte.setColorFill(new BaseColor(this.totalScoreColor));
            this.moveText(this.contentByte, this.totalScore + this.scoreSuffix, this.x, this.y - this.totalScoreColorFontSize / 2.0f, 1, 0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawItemNameAndScore() {
        this.getClass();
        float space = 360.0f / 3600.0f;
        float temp0 = 0.0f;
        int num = this.itemNames.length;
        float f = 1.0f / (float)num;
        this.getClass();
        float everyErea = f * 3600.0f;
        space = everyErea * space / 2.0f;
        this.contentByte.setColorStroke(BaseColor.BLACK);
        for (int i = 0; i < num; ++i) {
            temp0 = this.drawRotationText(this.itemNames[i], everyErea, space + this.rotation, this.r, i);
            this.drawRotationText(this.scores[i] + this.scoreSuffix, everyErea, space + this.rotation, this.r - temp0 - 2.0f, i);
            space += everyErea / 2.0f;
        }
    }

    private float drawRotationText(String text, float everyErea, float curSpace, float curR, int index) {
        this.getClass();
        double l = (double)(everyErea * 360.0f / 3600.0f) * Math.PI * (double)this.r / 180.0;
        int lineNo = (int)Math.ceil((double)this.calTextsWidth(text) / (l * 0.76));
        String tempText = null;
        int everyLen = Math.round(text.length() / lineNo);
        int benIndex = 0;
        int endIndex = 0;
        float temp = curR;
        for (int i = 0; i < lineNo; ++i) {
            endIndex = i == lineNo - 1 ? text.length() : everyLen * (i + 1);
            tempText = text.substring(benIndex, endIndex);
            this.drawRotationText_(temp -= this.fontSize, curSpace, tempText, index);
            benIndex = endIndex;
        }
        return (float)lineNo * this.fontSize;
    }

    private void drawRotationText_(float curR, float curSpace, String text, int index) {
        float t0 = this.calTextsWidth(text);
        float avgFontSize = t0 / (float)text.length();
        avgFontSize = avgFontSize * 80.0f / this.r;
        float benSpace = curSpace - t0 / 2.0f * 80.0f / this.r + avgFontSize / 2.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        int num = text.length();
        for (int i = 0; i < num; ++i) {
            this.contentByte.setColorFill(this.fontColor_);
            double d = curR;
            double d2 = Math.PI * (double)benSpace;
            this.getClass();
            x0 = this.x + (float)(d * Math.sin(d2 / 180.0));
            double d3 = curR;
            double d4 = Math.PI * (double)benSpace;
            this.getClass();
            y0 = this.y + (float)(d3 * Math.cos(d4 / 180.0));
            this.moveText(this.contentByte, text.charAt(i) + "", x0, y0, 1, 360.0f - benSpace);
            benSpace += avgFontSize;
        }
    }

    private void drawPoint(BaseColor[] fillColors) {
        this.getClass();
        float space = 360.0f / 3600.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        TPoint top = new TPoint();
        int num = this.itemNames.length;
        float f = 1.0f / (float)num;
        this.getClass();
        float everyErea = f * 3600.0f;
        space = everyErea * space / 2.0f;
        for (int i = 0; i < num; ++i) {
            this.contentByte.setColorStroke(fillColors[i]);
            double d = this.r - this.sectorWidth - this.pointHeight;
            double d2 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            top.setX(this.x + (float)(d * Math.sin(d2 / 180.0)));
            double d3 = this.r - this.sectorWidth - this.pointHeight;
            double d4 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            top.setY(this.y + (float)(d3 * Math.cos(d4 / 180.0)));
            float f2 = 0.0f;
            while (f2 <= this.pointWidth * 2.0f) {
                double d5 = this.r - this.sectorWidth * 9.0f / 10.0f;
                double d6 = Math.PI * (double)(space - this.pointWidth + f2 + this.rotation);
                this.getClass();
                x0 = this.x + (float)(d5 * Math.sin(d6 / 180.0));
                double d7 = this.r - this.sectorWidth * 9.0f / 10.0f;
                double d8 = Math.PI * (double)(space - this.pointWidth + f2 + this.rotation);
                this.getClass();
                y0 = this.y + (float)(d7 * Math.cos(d8 / 180.0));
                this.moveLine(this.contentByte, top.getX(), top.getY(), x0, y0);
                f2 = (float)((double)f2 + 0.1);
            }
            space += everyErea / 2.0f;
        }
    }

    private void drawOneFillCircle(float curR, BaseColor[] fillColors) {
        float space;
        this.getClass();
        float spaceSize = space = 360.0f / 3600.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        int num = this.itemNames.length;
        float[] everyEreas = new float[num];
        for (int i = 0; i < num; ++i) {
            float f = 1.0f / (float)num;
            this.getClass();
            everyEreas[i] = f * 3600.0f;
        }
        int areaNum = 0;
        float areaSum = everyEreas[areaNum];
        for (int i = 0; i < this.SIDE_NUM; ++i) {
            if ((float)i <= areaSum) {
                this.contentByte.setColorStroke(fillColors[areaNum]);
            } else {
                areaSum += everyEreas[++areaNum];
            }
            double d = curR;
            double d2 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            x0 = this.x + (float)(d * Math.sin(d2 / 180.0));
            double d3 = curR;
            double d4 = Math.PI * (double)(space + this.rotation);
            this.getClass();
            y0 = this.y + (float)(d3 * Math.cos(d4 / 180.0));
            this.moveLine(this.contentByte, this.x, this.y, x0, y0);
            space += spaceSize;
        }
    }

    private float calTextsWidth(String text) {
        char[] chs = text.toCharArray();
        float textWidth = 0.0f;
        for (char c : chs) {
            if (c < '\u00ff') {
                textWidth += this.fontSize / 2.0f;
                continue;
            }
            textWidth += this.fontSize;
        }
        return textWidth;
    }

    public CircleSeparateManySectorsChart setX(float x) {
        this.x = x;
        return this;
    }

    public CircleSeparateManySectorsChart setSectorWidth(float sectorWidth) {
        this.sectorWidth = sectorWidth;
        return this;
    }

    public CircleSeparateManySectorsChart setR(float r) {
        this.r = r;
        return this;
    }

    public CircleSeparateManySectorsChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public CircleSeparateManySectorsChart setScoreSuffix(String scoreSuffix) {
        this.scoreSuffix = scoreSuffix;
        return this;
    }

    public CircleSeparateManySectorsChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public CircleSeparateManySectorsChart setTotalScoreName(String totalScoreName) {
        this.totalScoreName = totalScoreName;
        return this;
    }

    public CircleSeparateManySectorsChart setTotalScore(float totalScore) {
        this.totalScore = totalScore;
        return this;
    }

    public CircleSeparateManySectorsChart setShowPoint(boolean showPoint) {
        this.showPoint = showPoint;
        return this;
    }

    public CircleSeparateManySectorsChart setY(float y) {
        this.y = y;
        return this;
    }

    public CircleSeparateManySectorsChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.r - 5.0f;
        return this.positionY;
    }

    public CircleSeparateManySectorsChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public CircleSeparateManySectorsChart setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public CircleSeparateManySectorsChart setFillColors(int[] fillColors) {
        this.fillColors = fillColors;
        return this;
    }

    public CircleSeparateManySectorsChart setTotalScoreNameColor(int totalScoreNameColor) {
        this.totalScoreNameColor = totalScoreNameColor;
        return this;
    }

    public CircleSeparateManySectorsChart setTotalScoreColor(int totalScoreColor) {
        this.totalScoreColor = totalScoreColor;
        return this;
    }

    public CircleSeparateManySectorsChart setTotalScoreColorFontSize(float totalScoreColorFontSize) {
        this.totalScoreColorFontSize = totalScoreColorFontSize;
        return this;
    }

    public CircleSeparateManySectorsChart setPointWidth(float pointWidth) {
        this.pointWidth = pointWidth;
        return this;
    }

    public CircleSeparateManySectorsChart setPointHeight(float pointHeight) {
        this.pointHeight = pointHeight;
        return this;
    }
}

