/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.nbmf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.unit.FourTopQuadrilateralGraph;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class TableChartedPositionAreaCurveScoresChart
extends AbstractChart {
    private float width = 450.0f;
    private float fontSize = 8.0f;
    private int fontColor = 0;
    private float lineHeight = 15.0f;
    private String[] tableHeads;
    private int[] scoreLevels;
    private int tableHeadColor = 93348;
    private int tableHeadFontColor = 0xFFFFFF;
    private String[] parentTypes;
    private int parentTypeColor = 14480379;
    private List<String[]> childrenTypes;
    private float[][] scores;
    private float tableHeadFontSize = 10.0f;
    private float firstColumnFontSize = 9.0f;
    private int[] rowColors;
    private float positionY;
    private int maxScoreColNum = 3;
    private int minScoreColNum = 2;
    private int curScoreColNum = 0;
    private int curveColor = 5210557;
    private float[] widths;
    private float levelFontSize = 7.0f;
    private int borderColor = 3245468;
    private int verticalLineColor = 0xD0D0D0;
    private int verticalAreaColor = 15857146;
    private float gradeRectangeGap = 15.0f;
    private float[] realRowHeight;
    private int lineNumber;
    private FourTopQuadrilateralGraph fillAreaGraph;

    public TableChartedPositionAreaCurveScoresChart() {
    }

    public TableChartedPositionAreaCurveScoresChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, this.childrenTypes) || this.childrenTypes.isEmpty() || ObjectUtils.equals(null, (Object)this.tableHeads) || this.tableHeads.length < 1 || ObjectUtils.equals(null, (Object)this.parentTypes) || this.parentTypes.length < 1 || ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4btableHeads\u3001childrenTypes\u3001parentTypes\u3001scores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.scoreLevels)) {
            this.scoreLevels = new int[]{0, 1, 2, 3, 4, 5};
        }
        if (ObjectUtils.equals(null, (Object)this.widths)) {
            this.widths = new float[]{10.0f, 30.0f, 5.0f, 5.0f, 5.0f, 5.0f, 50.0f};
        }
        if (ObjectUtils.equals(null, (Object)this.rowColors)) {
            this.rowColors = new int[]{0xFFFFFF, 0xF2F2F2};
        }
        this.fillAreaGraph = new FourTopQuadrilateralGraph(this.writer, this.contentByte, this.document);
        this.fillAreaGraph.setBaseChart(this);
        this.fillAreaGraph.setColor(this.verticalAreaColor);
        try {
            float sum = 0.0f;
            for (float w : this.widths) {
                sum += w;
            }
            float y0 = this.writer.getVerticalPosition(true);
            this.checkPositionHeight(y0, sum);
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            if (this.lineNumber <= 0) {
                this.document.newPage();
            }
            this.addTableHead(sum);
            this.addTableBody(borderColor_, sum);
            this.lineNumber = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int checkPositionHeight(float y0, float sum) {
        float curHeight = this.lineHeight + this.gradeRectangeGap + 15.0f;
        float temp = this.calTableHeadRowHeight(sum);
        curHeight += temp;
        for (int i = 0; i < this.childrenTypes.size(); ++i) {
            int j;
            for (j = 0; j < this.childrenTypes.get(i).length; ++j) {
                temp = this.everyColHeight(this.childrenTypes.get(i)[j], 1, sum);
                curHeight += temp;
            }
            if (curHeight > y0) {
                return this.lineNumber;
            }
            this.lineNumber += j;
        }
        return this.lineNumber;
    }

    private void drawMulRowText(float lineHeight, float witdh, float fontSize, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, fontSize, witdh, lineHeight, x, y, 0);
    }

    private void addTableBody(BaseColor borderColor, float sum) throws Exception {
        float x;
        float y;
        float y0 = y = this.writer.getVerticalPosition(true);
        float x0 = x = (this.document.getPageSize().getWidth() - this.width) / 2.0f;
        BaseColor fontColor_ = new BaseColor(this.fontColor);
        int[] colSpan = new int[this.childrenTypes.size()];
        ArrayList<Object> childStr = new ArrayList<Object>();
        for (int i = 0; i < this.childrenTypes.size(); ++i) {
            colSpan[i] = this.childrenTypes.get(i).length;
            childStr.addAll(Arrays.asList((Object[])this.childrenTypes.get(i)));
        }
        this.realRowHeight = new float[this.scores.length];
        float[] rowScores = null;
        boolean isNewPage = true;
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        for (int i = 0; i < this.scores.length; ++i) {
            if (this.lineNumber > 0 && isNewPage && i + 1 > this.lineNumber) {
                this.drawTextAndScore(y, colSpan, sum, borderColor, true);
                this.document.newPage();
                this.setLine(1, this.gradeRectangeGap, this.document);
                this.addTableHead(sum);
                y = y0 = this.writer.getVerticalPosition(true);
                isNewPage = false;
                this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            }
            rowScores = this.scores[i];
            this.realRowHeight[i] = this.everyColHeight((String)childStr.get(i) + "", 1, sum);
            int curColColor = 0;
            String text = null;
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setColorFill(fontColor_);
            this.contentByte.setLineWidth(0.5f);
            this.moveLine(this.contentByte, x0 + 0.5f, y0, x0 + 0.5f, y0 - this.realRowHeight[i]);
            for (int curCol = 1; curCol < this.widths.length; ++curCol) {
                this.contentByte.setLineWidth(1.5f);
                curColColor = curCol == this.widths.length - 1 || (i + 1) % 2 == 1 ? this.rowColors[0] : this.rowColors[1];
                if (curCol == 1) {
                    text = (String)childStr.get(i);
                } else if (curCol != this.widths.length - 1) {
                    text = rowScores[curCol - 2] + "";
                }
                this.contentByte.setColorStroke(borderColor);
                this.moveLine(this.contentByte, x0 += this.widths[curCol - 1] * this.width / sum, y0, x0, y0 - this.realRowHeight[i] + 0.5f);
                this.moveRect(this.contentByte, x0, y0, x0 + this.widths[curCol] * this.width / sum, y0 - this.realRowHeight[i], curColColor, new boolean[0]);
                if (curCol != this.widths.length - 1) {
                    this.contentByte.setColorFill(fontColor_);
                    this.drawMulRowText(this.realRowHeight[i], this.widths[curCol] * this.width / sum, this.fontSize, text, x0, y0);
                }
                if ((!isNewPage || this.lineNumber <= 0 || i + 1 < this.lineNumber) && (isNewPage && this.lineNumber > 0 || i != this.scores.length - 1)) continue;
                this.contentByte.setLineWidth(0.5f);
                this.moveLine(this.contentByte, x0 - this.widths[curCol - 1] * this.width / sum, y0 - this.realRowHeight[i], x0, y0 - this.realRowHeight[i]);
                if (this.widths.length - 1 != curCol) continue;
                this.moveLine(this.contentByte, x0, y0 - this.realRowHeight[i], x0 + this.widths[curCol] * this.width / sum, y0 - this.realRowHeight[i]);
            }
            y0 -= this.realRowHeight[i];
            x0 = x;
        }
        this.drawTextAndScore(y, colSpan, sum, borderColor, new boolean[0]);
        this.calPositionY(y);
    }

    private void drawArea(float y0, float x0, float sepWidth, boolean ... isNewPage) {
        y0 = this.lineNumber > 0 && this.lineNumber != this.scores.length && isNewPage.length < 1 ? (y0 -= this.realRowHeight[this.lineNumber]) : (y0 -= this.realRowHeight[0]);
        float[] rowScores = null;
        int l = this.scores.length;
        for (int i = this.lineNumber > 0 && this.lineNumber != this.scores.length && isNewPage.length < 1 ? this.lineNumber + 1 : 1; i < l; ++i) {
            rowScores = this.scores[i - 1];
            this.fillAreaGraph.setFirst_x(x0 + sepWidth * (rowScores[this.maxScoreColNum] - (float)this.scoreLevels[0])).setFirst_y(y0 + this.realRowHeight[i - 1] / 2.0f).setFourth_x(x0 + sepWidth * (rowScores[this.minScoreColNum] - (float)this.scoreLevels[0])).setFourth_y(y0 + this.realRowHeight[i - 1] / 2.0f);
            rowScores = this.scores[i];
            this.fillAreaGraph.setSecond_x(x0 + sepWidth * (rowScores[this.maxScoreColNum] - (float)this.scoreLevels[0])).setSecond_y(y0 - this.realRowHeight[i] / 2.0f).setThird_x(x0 + sepWidth * (rowScores[this.minScoreColNum] - (float)this.scoreLevels[0])).setThird_y(y0 - this.realRowHeight[i] / 2.0f);
            this.fillAreaGraph.chart();
            y0 -= this.realRowHeight[i];
            if (isNewPage.length > 0 && isNewPage[0] && i + 1 >= this.lineNumber) break;
        }
    }

    private float rowHeightSum(int curRow, int[] colSpan) {
        int benRow = 0;
        for (int i = 0; i <= curRow - 1; ++i) {
            benRow += colSpan[i];
        }
        float sum = 0.0f;
        for (int i = benRow; i < benRow + colSpan[curRow]; ++i) {
            sum += this.realRowHeight[i];
        }
        return sum;
    }

    private void drawTextAndScore(float y, int[] colSpan, float sum, BaseColor borderColor, boolean ... isNewPage) {
        float y0 = y - this.fontSize;
        float cellHeight = 0.0f;
        float yt = y0;
        float x0 = (this.document.getPageSize().getWidth() - this.width) / 2.0f + this.widths[0] * this.width / sum / 2.0f;
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        float everyCell = this.width * this.widths[this.widths.length - 1] / sum;
        float sepWidth = everyCell / (float)(this.scoreLevels[this.scoreLevels.length - 1] - this.scoreLevels[0]);
        int rows = 0;
        for (int i1 = 0; i1 < colSpan.length; ++i1) {
            if ((isNewPage.length < 1 || !isNewPage[0]) && this.lineNumber > 0 && this.lineNumber < this.realRowHeight.length && (rows += colSpan[i1]) <= this.lineNumber) continue;
            cellHeight = this.rowHeightSum(i1, colSpan);
            this.contentByte.setLineWidth(1.0f);
            this.moveRect(this.contentByte, x0 - this.widths[0] * this.width / sum / 2.0f + 1.0f, i1 == 0 ? y0 + this.fontSize : y0 + this.fontSize, x0 + this.widths[0] * this.width / sum / 2.0f - 2.0f, y0 - cellHeight + this.fontSize + 1.2f, this.parentTypeColor, true);
            this.contentByte.setFontAndSize(this.baseFont, this.firstColumnFontSize);
            this.drawMulRowText(cellHeight, this.widths[0] * this.width / sum, this.firstColumnFontSize, this.parentTypes[i1], x0 - this.widths[0] * this.width / sum / 2.0f + 1.0f, y0 + this.firstColumnFontSize);
            y0 = yt -= cellHeight;
            if (isNewPage.length > 0 && isNewPage[0] && rows >= this.lineNumber) break;
        }
        rows = 0;
        y0 = y;
        BaseColor curveColor_ = new BaseColor(this.curveColor);
        BaseColor verticalLineColor_ = new BaseColor(this.verticalLineColor);
        x0 += this.width - this.widths[this.widths.length - 1] * this.width / sum;
        this.drawArea(y0, x0 -= this.widths[0] * this.width / sum / 2.0f, sepWidth, isNewPage);
        float[] rowScores = null;
        int l = this.scores.length;
        for (int i = (isNewPage.length < 1 || !isNewPage[0]) && this.lineNumber < this.scores.length ? this.lineNumber : 0; i < l; ++i) {
            rowScores = this.scores[i];
            y0 -= this.realRowHeight[i];
            if (i > 0 && i != this.lineNumber) {
                this.contentByte.setColorStroke(curveColor_);
                this.moveLine(this.contentByte, x0 + sepWidth * (this.scores[i - 1][this.curScoreColNum] - (float)this.scoreLevels[0]), y0 + this.realRowHeight[i] + this.realRowHeight[i - 1] / 2.0f, x0 + sepWidth * (rowScores[this.curScoreColNum] - (float)this.scoreLevels[0]), y0 + this.realRowHeight[i] / 2.0f);
            }
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineWidth(0.5f);
            this.moveLine(this.contentByte, x0 + everyCell, y0, x0 + everyCell, y0 + this.realRowHeight[i]);
            this.contentByte.setColorStroke(verticalLineColor_);
            this.contentByte.setLineWidth(1.0f);
            this.moveLine(this.contentByte, x0, y0 + this.realRowHeight[i] / 2.0f, x0 + sepWidth * (rowScores[this.curScoreColNum] - (float)this.scoreLevels[0]), y0 + this.realRowHeight[i] / 2.0f);
            this.contentByte.setColorStroke(curveColor_);
            this.moveCircle(this.contentByte, x0 + sepWidth * (rowScores[this.curScoreColNum] - (float)this.scoreLevels[0]), y0 + this.realRowHeight[i] / 2.0f, 2.5f, true);
            if (isNewPage.length > 0 && isNewPage[0] && i + 1 >= this.lineNumber) break;
        }
    }

    private void addTableHead(float sum) throws Exception {
        PdfPTable headTable = new PdfPTable(this.widths.length);
        headTable.setTotalWidth(this.width);
        headTable.setLockedWidth(true);
        headTable.setWidths(this.widths);
        PdfPCell cell = null;
        BaseColor baseColor_ = new BaseColor(this.tableHeadColor);
        BaseColor tableHeadFontColor_ = new BaseColor(this.tableHeadFontColor);
        float rowHeight = this.calTableHeadRowHeight(sum);
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < this.tableHeads.length; ++i) {
                cell = k == 0 && i != this.tableHeads.length - 1 ? this.addOneCell(new Font(this.baseFont, this.tableHeadFontSize, 0, tableHeadFontColor_), this.tableHeads[i], rowHeight, baseColor_, true) : this.addOneCell(new Font(this.baseFont, this.tableHeadFontSize, 0, BaseColor.BLACK), "", 0.0f, baseColor_, false);
                cell.setBorderColor(BaseColor.WHITE);
                headTable.addCell(cell);
            }
        }
        this.document.add((Element)headTable);
        float everyCell = this.width * this.widths[this.widths.length - 1] / sum;
        float sepWidth = everyCell / (float)(this.scoreLevels[this.scoreLevels.length - 1] - this.scoreLevels[0]);
        float posstion = (this.document.getPageSize().getWidth() - this.width) / 2.0f + this.width - everyCell + 3.0f;
        float y = this.writer.getVerticalPosition(true) + 3.0f;
        float offsetX = 0.0f;
        this.contentByte.setFontAndSize(this.baseFont, this.levelFontSize);
        this.contentByte.setColorFill(tableHeadFontColor_);
        for (int i = 0; i < this.scoreLevels.length; ++i) {
            offsetX = (float)(this.scoreLevels[i] - this.scoreLevels[0]) * sepWidth;
            if (i == this.scoreLevels.length - 1) {
                offsetX -= 5.0f;
            }
            this.moveText(this.contentByte, this.scoreLevels[i] + "", offsetX + posstion, y, i == this.scoreLevels.length - 1 ? 2 : 1, 0.0f);
        }
    }

    private float everyColHeight(String str, int curCol, float totalWidth) {
        float extendHeight = 0.0f;
        float everyCell = this.width * this.widths[curCol] / totalWidth;
        extendHeight = this.calTextWidth(this.fontSize, str) / everyCell;
        extendHeight = extendHeight > 1.0f ? (float)Math.ceil(extendHeight) : 1.0f;
        return extendHeight * this.lineHeight;
    }

    private float calTableHeadRowHeight(float colWidth) {
        float sum = 0.0f;
        float width = 0.0f;
        int len = this.tableHeads.length;
        for (int i = 0; i < len; ++i) {
            width = this.width * this.widths[i] / colWidth;
            sum = Math.max(sum, this.calTextWidth(this.tableHeadFontSize, this.tableHeads[i]) / width);
        }
        return (float)((int)Math.ceil(sum)) * this.tableHeadFontSize + this.lineHeight;
    }

    private PdfPCell addOneCell(Font pFont, String str, float height, BaseColor backColor, boolean isHasHeight) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(str, pFont));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setBackgroundColor(backColor);
        if (isHasHeight) {
            cell.setPaddingTop(0.0f);
            cell.setPaddingBottom(3.0f);
            cell.setFixedHeight(height);
        } else {
            cell.setPaddingTop(0.0f);
            cell.setPaddingBottom(0.0f);
            cell.setFixedHeight(height);
        }
        cell.setNoWrap(false);
        return cell;
    }

    public TableChartedPositionAreaCurveScoresChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setTableHeadFontColor(int tableHeadFontColor) {
        this.tableHeadFontColor = tableHeadFontColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setTableHeads(String[] tableHeads) {
        this.tableHeads = tableHeads;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setScoreLevels(int[] scoreLevels) {
        this.scoreLevels = scoreLevels;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setTableHeadColor(int tableHeadColor) {
        this.tableHeadColor = tableHeadColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setParentTypes(String[] parentTypes) {
        this.parentTypes = parentTypes;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setParentTypeColor(int parentTypeColor) {
        this.parentTypeColor = parentTypeColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setChildrenTypes(List<String[]> childrenTypes) {
        this.childrenTypes = childrenTypes;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setScores(float[][] scores) {
        this.scores = scores;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setRowColors(int[] rowColors) {
        this.rowColors = rowColors;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setCurveColor(int curveColor) {
        this.curveColor = curveColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setWidths(float[] widths) {
        this.widths = widths;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setLevelFontSize(float levelFontSize) {
        this.levelFontSize = levelFontSize;
        return this;
    }

    public float getPositionY() {
        return this.positionY;
    }

    public TableChartedPositionAreaCurveScoresChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setVerticalLineColor(int verticalLineColor) {
        this.verticalLineColor = verticalLineColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setVerticalAreaColor(int verticalAreaColor) {
        this.verticalAreaColor = verticalAreaColor;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setGradeRectangeGap(float gradeRectangeGap) {
        this.gradeRectangeGap = gradeRectangeGap;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setTableHeadFontSize(float tableHeadFontSize) {
        this.tableHeadFontSize = tableHeadFontSize;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setFirstColumnFontSize(float firstColumnFontSize) {
        this.firstColumnFontSize = firstColumnFontSize;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setMaxScoreColNum(int maxScoreColNum) {
        this.maxScoreColNum = maxScoreColNum;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setMinScoreColNum(int minScoreColNum) {
        this.minScoreColNum = minScoreColNum;
        return this;
    }

    public TableChartedPositionAreaCurveScoresChart setCurScoreColNum(int curScoreColNum) {
        this.curScoreColNum = curScoreColNum;
        return this;
    }

    private void calPositionY(float y) {
        int i;
        float y0 = 0.0f;
        int n = i = this.lineNumber > 0 && this.lineNumber < this.realRowHeight.length ? this.lineNumber : 0;
        while (i < this.realRowHeight.length) {
            y0 += this.realRowHeight[i];
            ++i;
        }
        this.positionY = y - y0 - 5.0f;
    }
}

