/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.nbmf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.unit.BalloonGraph;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class TableGradeDistributionOnlyTextChart
extends AbstractChart {
    private float x;
    private float width = 450.0f;
    private float y;
    private String[] gradeNames;
    private String[] gradeDescs;
    private int[] gradeBackgroundColors;
    private String curNumber;
    private float curPercentage;
    private float maxNumber;
    private float fontSize = 8.0f;
    private int fontColor = 0;
    private boolean isMarkCurPositon = true;
    private int sepLineColor = 0xAEAEAE;
    private float sepTopMargin = 1.3f;
    private float sepLineWidth = 1.8f;
    private boolean isShowSepLine;
    private float positionY;
    private float cellHeight = 15.0f;
    private float[] widths;

    public TableGradeDistributionOnlyTextChart() {
    }

    public TableGradeDistributionOnlyTextChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.gradeNames)) {
            this.gradeNames = new String[]{"\u4f18\u79c0", "\u826f\u597d", "\u5408\u683c", "\u5f85\u53d1\u5c55"};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeBackgroundColors)) {
            this.gradeBackgroundColors = new int[]{6149040, 9621584, 0xFFC000, 16552507};
        }
        if (ObjectUtils.equals(null, (Object)this.widths)) {
            this.widths = new float[]{10.0f, 30.0f, 50.0f, 10.0f};
        }
        BaseColor fontColor_ = new BaseColor(this.fontColor);
        try {
            this.contentByte.setLineWidth(1.0f);
            this.contentByte.setColorFill(fontColor_);
            this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
            float sum = 0.0f;
            for (float w : this.widths) {
                sum += w;
            }
            float celHeight = this.calRowHeight(sum);
            this.drawTable(sum, celHeight);
            if (this.isMarkCurPositon) {
                this.drawCurPosition(celHeight);
            }
            if (this.isShowSepLine) {
                this.contentByte.setColorStroke(new BaseColor(this.sepLineColor));
                this.contentByte.setLineWidth(this.sepLineWidth);
                this.moveLine(this.contentByte, this.x, this.y - celHeight - this.sepTopMargin - this.sepLineWidth, this.x + this.width, this.y - celHeight - this.sepTopMargin - this.sepLineWidth);
                this.positionY = this.sepTopMargin + this.sepLineWidth;
            }
            this.positionY += celHeight;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private float calRowHeight(float sum) {
        float celHeight = 0.0f;
        int lineNo = 0;
        for (int i = 0; i < this.gradeNames.length; ++i) {
            lineNo = (int)Math.ceil((float)this.gradeNames[i].length() * this.fontSize / (this.width * this.widths[i] / sum));
            if (ObjectUtils.notEqual(null, (Object)this.gradeDescs)) {
                lineNo += (int)Math.ceil((float)this.gradeDescs[i].length() * this.fontSize / (this.width * this.widths[i] / sum));
            }
            celHeight = Math.max(celHeight, (float)lineNo * this.fontSize + this.cellHeight + (float)lineNo);
        }
        return celHeight;
    }

    private void drawTable(float sum, float celHeight) {
        float x0 = this.x;
        float tempH = 0.0f;
        float yt = 0.0f;
        int nameLineNo = 0;
        int descLineNo = 0;
        int sepSpace = 2;
        if (ObjectUtils.notEqual(null, (Object)this.gradeDescs)) {
            sepSpace = 3;
        }
        for (int i = 0; i < this.gradeNames.length; ++i) {
            this.moveRect(this.contentByte, x0, this.y, x0 + this.width * this.widths[i] / sum - 1.0f, this.y - celHeight, this.gradeBackgroundColors[i], new boolean[0]);
            nameLineNo = (int)Math.ceil((float)this.gradeNames[i].length() * this.fontSize / (this.width * this.widths[i] / sum));
            if (ObjectUtils.notEqual(null, (Object)this.gradeDescs)) {
                descLineNo = (int)Math.ceil((float)this.gradeDescs[i].length() * this.fontSize / (this.width * this.widths[i] / sum));
            }
            tempH = this.fontSize * (float)(nameLineNo + descLineNo);
            yt = (celHeight - tempH) / (float)sepSpace;
            this.drawMulRowText((float)nameLineNo * this.fontSize + yt * 2.0f, this.width * this.widths[i] / sum, this.gradeNames[i], x0, this.y);
            if (ObjectUtils.notEqual(null, (Object)this.gradeDescs)) {
                this.drawMulRowText((float)descLineNo * this.fontSize + yt * 2.0f, this.width * this.widths[i] / sum, this.gradeDescs[i], x0, this.y - (float)nameLineNo * this.fontSize - yt);
            }
            x0 += this.width * this.widths[i] / sum;
        }
    }

    private void drawMulRowText(float lineHeight, float witdh, String text, float x, float y) {
        this.moveMultiLineText(this.contentByte, text, this.fontSize, witdh, lineHeight, x, y, 0);
    }

    private void drawCurPosition(float celHeight) throws Exception {
        BalloonGraph balloonGraph = new BalloonGraph(this.writer, this.contentByte, this.document);
        balloonGraph.setBaseChart(this);
        balloonGraph.setY(this.y - celHeight).setLineHeight(celHeight).setAreaHeight(8.0f).setBallR(this.fontSize * (float)(this.curNumber.length() > 4 ? this.curNumber.length() : 4) * 1.1f / 3.0f).setX(this.x + this.curPercentage * this.width / this.maxNumber);
        balloonGraph.chart();
        this.moveText(this.contentByte, this.curNumber, this.x + this.curPercentage * this.width / this.maxNumber, this.y + 8.0f + this.fontSize * (float)(this.curNumber.length() > 4 ? this.curNumber.length() : 4) * 1.1f / 4.0f, 1, 0.0f);
    }

    public TableGradeDistributionOnlyTextChart setX(float x) {
        this.x = x;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setY(float y) {
        this.y = y;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setGradeNames(String[] gradeNames) {
        this.gradeNames = gradeNames;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setGradeBackgroundColors(int[] gradeBackgroundColors) {
        this.gradeBackgroundColors = gradeBackgroundColors;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public float getPositionY() {
        this.positionY = this.y - this.positionY - 5.0f;
        return this.positionY;
    }

    public TableGradeDistributionOnlyTextChart setGradeDescs(String[] gradeDescs) {
        this.gradeDescs = gradeDescs;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setCurNumber(String curNumber) {
        this.curNumber = curNumber;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setMaxNumber(float maxNumber) {
        this.maxNumber = maxNumber;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setMarkCurPositon(boolean isMarkCurPositon) {
        this.isMarkCurPositon = isMarkCurPositon;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setSepLineColor(int sepLineColor) {
        this.sepLineColor = sepLineColor;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setShowSepLine(boolean isShowSepLine) {
        this.isShowSepLine = isShowSepLine;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setCellHeight(float cellHeight) {
        this.cellHeight = cellHeight;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setWidths(float[] widths) {
        this.widths = widths;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setSepTopMargin(float sepTopMargin) {
        this.sepTopMargin = sepTopMargin;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setCurPercentage(float curPercentage) {
        this.curPercentage = curPercentage;
        return this;
    }

    public TableGradeDistributionOnlyTextChart setSepLineWidth(float sepLineWidth) {
        this.sepLineWidth = sepLineWidth;
        return this;
    }
}

