/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.nbmf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.base.unit.FourTopQuadrilateralGraph;
import com.xianghy.itextpdf.tools.base.unit.RectangleLineThroughGraph;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import org.apache.commons.lang3.ObjectUtils;

public class TableGradeSimpleAreaCurveChart
extends AbstractChart {
    private float width = 450.0f;
    private float height = 120.0f;
    private float x;
    private float y;
    private float[] levels;
    private float fontSize = 9.0f;
    private int fontColor = 0;
    private float lineHeight = 20.0f;
    private String[] itemNames;
    private float[] scores;
    private int tableBorderColor = 0xBFBFBF;
    private int tableBackgroundColor = 0xF2F2F2;
    private float positionY;
    private int curveColor = 5210557;
    private float levelFontSize = 8.0f;
    private int levelFontColor = 5610690;
    private int borderColor = 0x7F7F7F;
    private String[] gradeNames;
    private int[] gradeColors;
    private float[] gradeUpperLimitScore;
    private int verticalLineColor = 0xD0D0D0;
    private int verticalAreaColor = 0xFAFAFA;
    private float gradeRectangeGap = 15.0f;
    private FourTopQuadrilateralGraph fillAreaGraph;

    public TableGradeSimpleAreaCurveChart() {
    }

    public TableGradeSimpleAreaCurveChart(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        this.positionY = 0.0f;
        if (ObjectUtils.equals(null, (Object)this.scores) || this.scores.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4bscores\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.levels)) {
            this.levels = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeNames)) {
            this.gradeNames = new String[]{"\u4f18\u79c0", "\u826f\u597d", "\u5408\u683c"};
        }
        if (ObjectUtils.equals(null, (Object)this.gradeColors)) {
            this.gradeColors = new int[]{6149040, 9621584, 0xFFC000};
        }
        this.fillAreaGraph = new FourTopQuadrilateralGraph(this.writer, this.contentByte, this.document);
        this.fillAreaGraph.setBaseChart(this);
        this.fillAreaGraph.setColor(this.verticalAreaColor);
        try {
            BaseColor borderColor_ = new BaseColor(this.borderColor);
            BaseColor fontColor_ = new BaseColor(this.fontColor);
            this.setLine(1, this.gradeRectangeGap, this.document);
            this.drawGradeDescs();
            this.drawArea();
            this.drawFrame(borderColor_);
            this.drawScoreGraph();
            this.addTableBody(fontColor_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawArea() {
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float sepWidth = this.width / (float)this.itemNames.length;
        float x0 = this.x + sepWidth * 3.0f / 2.0f;
        float y0 = this.y;
        int l = this.scores.length;
        for (int i = 1; i < l; ++i) {
            this.fillAreaGraph.setFirst_x(x0).setFirst_y(y0 + kHeight * (this.scores[i] - this.levels[0])).setSecond_x(x0).setSecond_y(y0).setThird_x(x0 - sepWidth).setThird_y(y0).setFourth_x(x0 - sepWidth).setFourth_y(y0 + kHeight * (this.scores[i - 1] - this.levels[0]));
            this.fillAreaGraph.chart();
            x0 += sepWidth;
        }
    }

    private void drawScoreGraph() {
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float sepWidth = this.width / (float)this.itemNames.length;
        float x0 = this.x + sepWidth / 2.0f;
        float y0 = this.y;
        BaseColor curveColor_ = new BaseColor(this.curveColor);
        BaseColor verticalLineColor_ = new BaseColor(this.verticalLineColor);
        int l = this.scores.length;
        for (int i = 0; i < l; ++i) {
            this.contentByte.setColorFill(curveColor_);
            this.contentByte.setColorStroke(curveColor_);
            this.moveCircle(this.contentByte, x0, y0 + kHeight * (this.scores[i] - this.levels[0]), 2.0f, true);
            this.contentByte.setColorStroke(verticalLineColor_);
            this.moveLine(this.contentByte, x0, y0, x0, y0 + kHeight * (this.scores[i] - this.levels[0]));
            if (i > 0) {
                this.contentByte.setColorFill(curveColor_);
                this.contentByte.setColorStroke(curveColor_);
                this.moveLine(this.contentByte, x0 - sepWidth, y0 + kHeight * (this.scores[i - 1] - this.levels[0]), x0, y0 + kHeight * (this.scores[i] - this.levels[0]));
            }
            x0 += sepWidth;
        }
    }

    private void drawFrame(BaseColor borderColor) {
        BaseColor fontColor_ = new BaseColor(this.levelFontColor);
        this.contentByte.setColorStroke(borderColor);
        this.contentByte.setLineWidth(1.0f);
        this.contentByte.setFontAndSize(this.baseFont, this.levelFontSize);
        this.moveLine(this.contentByte, this.x, this.y, this.x, this.y + this.height);
        float x1 = this.x;
        float kHeight = this.height / (this.levels[this.levels.length - 1] - this.levels[0]);
        float y1 = 0.0f;
        for (int i = 0; i < this.levels.length; ++i) {
            y1 = this.y + kHeight * (this.levels[i] - this.levels[0]);
            this.contentByte.setColorStroke(borderColor);
            this.contentByte.setLineDash(1.0f);
            this.moveLine(this.contentByte, x1, y1, this.x - 2.0f, y1);
            this.contentByte.setColorFill(fontColor_);
            this.moveText(this.contentByte, this.levels[i] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
        }
        this.contentByte.setColorFill(fontColor_);
        this.moveText(this.contentByte, this.levels[this.levels.length - 1] + "", x1 - 6.0f, y1 - 3.0f, 2, 0.0f);
        BaseColor gradeColor = null;
        int len = this.gradeUpperLimitScore.length;
        for (int i = 0; i < len; ++i) {
            gradeColor = new BaseColor(this.gradeColors[i]);
            this.contentByte.setColorStroke(gradeColor);
            y1 = this.y + kHeight * (this.gradeUpperLimitScore[i] - this.levels[0]);
            this.moveLine(this.contentByte, this.x, y1, this.x + this.width, y1);
        }
    }

    private void drawGradeDescs() {
        float y = this.y + this.height + this.gradeRectangeGap;
        float x = this.x + this.width - 15.0f;
        float rectangleWidth = 0.0f;
        RectangleLineThroughGraph gradeGraph = new RectangleLineThroughGraph(this.writer, this.contentByte, this.document);
        int len = this.gradeColors.length;
        for (int i = len - 1; i >= 0; --i) {
            rectangleWidth = 2.0f * this.calTextWidth(this.fontSize, this.gradeNames[i]);
            gradeGraph.setBaseChart(this);
            gradeGraph.setBaseFont(this.baseFont);
            gradeGraph.setHasLineThrough(true).setHeight(15.0f).setFontSize(this.fontSize).setLineThroughLength(30.0f).setY(y).setX(x -= rectangleWidth).setText(this.gradeNames[i]).setWidth(rectangleWidth).setColor(this.gradeColors[i]).setFontColor(0xFFFFFF);
            gradeGraph.chart();
            x -= 40.0f;
        }
    }

    private void addTableBody(BaseColor fontColor) throws Exception {
        int i;
        float temp;
        float sepWidth = this.width / (float)this.itemNames.length;
        float x0 = this.x;
        float y0 = this.y - 2.0f;
        this.contentByte.setFontAndSize(this.baseFont, this.fontSize);
        this.contentByte.setLineWidth(1.5f);
        BaseColor tableBorderColor_ = new BaseColor(this.tableBorderColor);
        this.contentByte.setColorStroke(tableBorderColor_);
        this.moveLine(this.contentByte, x0, y0, x0 + this.width, y0);
        this.positionY = temp = this.calTableHeadHeight(sepWidth);
        int len = this.itemNames.length;
        for (i = 0; i < len; ++i) {
            this.moveRect(this.contentByte, x0, y0, x0 + sepWidth - 1.0f, y0 - temp, this.tableBackgroundColor, new boolean[0]);
            this.contentByte.setColorStroke(tableBorderColor_);
            this.moveLine(this.contentByte, x0 + sepWidth, y0, x0 + sepWidth, y0 - temp);
            this.moveLine(this.contentByte, x0, y0, x0, y0 - temp);
            this.contentByte.setColorFill(fontColor);
            this.moveMultiLineWText(this.contentByte, this.itemNames[i], this.fontSize, sepWidth, temp, x0, y0, 0);
            x0 += sepWidth;
        }
        x0 = this.x;
        this.contentByte.setColorStroke(tableBorderColor_);
        this.moveLine(this.contentByte, x0, y0 -= temp, x0 + this.width, y0);
        len = this.scores.length;
        for (i = 0; i < len; ++i) {
            this.moveRect(this.contentByte, x0, y0, x0 + sepWidth - 1.0f, y0 - this.lineHeight, this.tableBackgroundColor, new boolean[0]);
            this.contentByte.setColorStroke(tableBorderColor_);
            this.moveLine(this.contentByte, x0 + sepWidth, y0, x0 + sepWidth, y0 - this.lineHeight);
            this.moveLine(this.contentByte, x0, y0, x0, y0 - this.lineHeight);
            this.contentByte.setColorFill(fontColor);
            this.moveMultiLineText(this.contentByte, this.scores[i] + "", this.fontSize, sepWidth, this.lineHeight, x0, y0, 0);
            x0 += sepWidth;
        }
        this.positionY += this.lineHeight;
        x0 = this.x;
        this.contentByte.setColorStroke(tableBorderColor_);
        this.moveLine(this.contentByte, x0, y0 -= this.lineHeight, x0 + this.width, y0);
    }

    private float calTableHeadHeight(float width) {
        String maxLenText = "";
        for (int i = 0; i < this.itemNames.length; ++i) {
            if (maxLenText.length() >= this.itemNames[i].length()) continue;
            maxLenText = this.itemNames[i];
        }
        return this.calRealHeight(maxLenText, this.fontSize, width, this.lineHeight);
    }

    public TableGradeSimpleAreaCurveChart setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setScores(float[] scores) {
        this.scores = scores;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setCurveColor(int curveColor) {
        this.curveColor = curveColor;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setLevelFontSize(float levelFontSize) {
        this.levelFontSize = levelFontSize;
        return this;
    }

    public float getPositionY() {
        return this.y - this.positionY - 10.0f;
    }

    public TableGradeSimpleAreaCurveChart setFontColor(int fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setGradeNames(String[] gradeNames) {
        this.gradeNames = gradeNames;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setGradeColors(int[] gradeColors) {
        this.gradeColors = gradeColors;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setGradeUpperLimitScore(float[] gradeUpperLimitScore) {
        this.gradeUpperLimitScore = gradeUpperLimitScore;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setVerticalLineColor(int verticalLineColor) {
        this.verticalLineColor = verticalLineColor;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setVerticalAreaColor(int verticalAreaColor) {
        this.verticalAreaColor = verticalAreaColor;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setGradeRectangeGap(float gradeRectangeGap) {
        this.gradeRectangeGap = gradeRectangeGap;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setHeight(float height) {
        this.height = height;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setX(float x) {
        this.x = x;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setY(float y) {
        this.y = y;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setTableBackgroundColor(int tableBackgroundColor) {
        this.tableBackgroundColor = tableBackgroundColor;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setItemNames(String[] itemNames) {
        this.itemNames = itemNames;
        return this;
    }

    public TableGradeSimpleAreaCurveChart setLevels(float[] levels) {
        this.levels = levels;
        return this;
    }
}

