/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.table;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class TableCommonTable
extends AbstractChart {
    private float width = 500.0f;
    private List<Object[]> rowDatas;
    private int borderColor = 0x1B1B1B;
    private float rowHeight = 10.0f;
    private float[] widths;
    private Integer firstColumnColors;
    private int firstColumnFontColor = 0;
    private int[] rowColors;
    private float fontSize = 12.0f;
    private int otherColumnFontColor = 0;
    private int otherColumnAlign = 1;
    private int firstRowBackgroundColor = 5541332;
    private int firstRowFontColor = 0xFFFFFF;
    private float firstRowFontSize = 12.0f;
    private int firstRowFontType = 1;

    public TableCommonTable() {
    }

    public TableCommonTable(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        if (ObjectUtils.equals(null, this.rowDatas) || this.rowDatas.isEmpty()) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4browDatas\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.rowColors)) {
            this.rowColors = new int[]{0xF2F2F2, 0xFFFFFF};
        }
        if (ObjectUtils.equals(null, (Object)this.widths)) {
            this.widths = new float[]{20.0f, 80.0f};
        }
        BaseColor firstRowFontColor_ = new BaseColor(this.firstRowFontColor);
        BaseColor firstRowBackgroundColor_ = new BaseColor(this.firstRowBackgroundColor);
        BaseColor borderColor_ = new BaseColor(this.borderColor);
        BaseColor firstColumnFontColor_ = new BaseColor(this.firstColumnFontColor);
        BaseColor otherColumnFontColor_ = new BaseColor(this.otherColumnFontColor);
        BaseColor[] rowColors_ = new BaseColor[]{new BaseColor(this.rowColors[0]), new BaseColor(this.rowColors[1])};
        BaseColor firstColumnColors_ = null;
        if (ObjectUtils.notEqual(null, (Object)this.firstColumnColors)) {
            firstColumnColors_ = new BaseColor(this.firstColumnColors.intValue());
        }
        try {
            PdfPTable pTable = new PdfPTable(this.widths.length);
            pTable.setTotalWidth(this.width);
            pTable.setLockedWidth(true);
            pTable.setWidths(this.widths);
            PdfPCell cell = null;
            Object[] datas = null;
            for (int i = 0; i < this.rowDatas.size(); ++i) {
                datas = this.rowDatas.get(i);
                for (int j = 0; j < datas.length; ++j) {
                    cell = i == 0 ? this.addOneCell(datas[j].toString(), this.firstRowFontSize, firstRowFontColor_, firstRowBackgroundColor_, borderColor_, this.firstRowFontType, 1) : (j == 0 ? this.addOneCell(datas[j].toString(), this.fontSize, firstColumnFontColor_, ObjectUtils.notEqual(null, (Object)firstColumnColors_) ? firstColumnColors_ : rowColors_[i % 2], borderColor_, 0, 1) : this.addOneCell(datas[j].toString(), this.fontSize, otherColumnFontColor_, rowColors_[i % 2], borderColor_, 0, this.otherColumnAlign));
                    pTable.addCell(cell);
                }
            }
            this.document.add((Element)pTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PdfPCell addOneCell(String str, float fontSize, BaseColor fontColor, BaseColor backColor, BaseColor borderColor, int style, int align) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(str, new Font(this.baseFont, fontSize, style, fontColor)));
        cell.setHorizontalAlignment(align);
        cell.setVerticalAlignment(5);
        cell.setBackgroundColor(backColor);
        cell.setBorderColor(borderColor);
        cell.setPaddingTop(this.rowHeight);
        cell.setPaddingBottom(this.rowHeight);
        return cell;
    }

    public TableCommonTable setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableCommonTable setRowDatas(List<Object[]> rowDatas) {
        this.rowDatas = rowDatas;
        return this;
    }

    public TableCommonTable setRowColors(int[] rowColors) {
        this.rowColors = rowColors;
        return this;
    }

    public TableCommonTable setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TableCommonTable setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public TableCommonTable setRowHeight(float rowHeight) {
        this.rowHeight = rowHeight;
        return this;
    }

    public TableCommonTable setWidths(float[] widths) {
        this.widths = widths;
        return this;
    }

    public TableCommonTable setFirstRowFontType(int firstRowFontType) {
        this.firstRowFontType = firstRowFontType;
        return this;
    }

    public TableCommonTable setFirstRowBackgroundColor(int firstRowBackgroundColor) {
        this.firstRowBackgroundColor = firstRowBackgroundColor;
        return this;
    }

    public TableCommonTable setFirstRowFontColor(int firstRowFontColor) {
        this.firstRowFontColor = firstRowFontColor;
        return this;
    }

    public TableCommonTable setFirstRowFontSize(float firstRowFontSize) {
        this.firstRowFontSize = firstRowFontSize;
        return this;
    }

    public TableCommonTable setFirstColumnColors(Integer firstColumnColors) {
        this.firstColumnColors = firstColumnColors;
        return this;
    }

    public TableCommonTable setFirstColumnFontColor(int firstColumnFontColor) {
        this.firstColumnFontColor = firstColumnFontColor;
        return this;
    }

    public TableCommonTable setOtherColumnFontColor(int otherColumnFontColor) {
        this.otherColumnFontColor = otherColumnFontColor;
        return this;
    }

    public TableCommonTable setOtherColumnAlign(int otherColumnAlign) {
        this.otherColumnAlign = otherColumnAlign;
        return this;
    }
}

