/*
 * Decompiled with CFR 0.152.
 */
package com.xianghy.itextpdf.tools.table;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.xianghy.itextpdf.tools.chart.AbstractChart;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class TableLikeSevenAndAlternateLine
extends AbstractChart {
    private float width = 440.0f;
    private String[] headDatas;
    private List<Object[]> rowDatas;
    private int firstColumnColor = 14413556;
    private int[] rowColors;
    private int headFontColor = 0xFFFFFF;
    private int headBackgroundColor = 93348;
    private float fontSize = 10.0f;

    public TableLikeSevenAndAlternateLine() {
    }

    public TableLikeSevenAndAlternateLine(PdfWriter writer, PdfContentByte contentByte, Document document, BaseFont baseFont) {
        super(writer, contentByte, document, baseFont);
    }

    @Override
    public void chart() {
        if (ObjectUtils.equals(null, this.rowDatas) || this.rowDatas.isEmpty() || ObjectUtils.equals(null, (Object)this.headDatas) || this.headDatas.length < 1) {
            throw new RuntimeException("\u8bf7\u68c0\u6d4browDatas\u3001headDatas\u6570\u636e\u662f\u5426\u5b58\u5728\uff01");
        }
        if (ObjectUtils.equals(null, (Object)this.rowColors)) {
            this.rowColors = new int[]{0xFFFFFF, 0xF2F2F2};
        }
        try {
            int i;
            BaseColor headFontColor_ = new BaseColor(this.headFontColor);
            BaseColor headBackgroundColor_ = new BaseColor(this.headBackgroundColor);
            BaseColor firstColumnColor_ = new BaseColor(this.firstColumnColor);
            BaseColor[] rowColors_ = new BaseColor[]{new BaseColor(this.rowColors[0]), new BaseColor(this.rowColors[1])};
            float[] ws = new float[this.headDatas.length];
            for (int i2 = 0; i2 < ws.length; ++i2) {
                ws[i2] = 100 / this.headDatas.length;
            }
            PdfPTable pTable = new PdfPTable(this.headDatas.length);
            pTable.setTotalWidth(this.width);
            pTable.setLockedWidth(true);
            pTable.setWidths(ws);
            PdfPCell cell = null;
            for (i = 0; i < this.headDatas.length; ++i) {
                cell = this.addOneCell(this.headDatas[i], "th", headFontColor_, headBackgroundColor_, headBackgroundColor_, 1, 0.0f, 10.0f);
                if (i > 0) {
                    cell.setBorderWidthLeft(1.5f);
                    cell.setBorderColorLeft(BaseColor.WHITE);
                }
                pTable.addCell(cell);
            }
            for (i = 0; i < this.rowDatas.size(); ++i) {
                Object[] aStr = this.rowDatas.get(i);
                for (int j = 0; j < aStr.length; ++j) {
                    cell = this.addOneCell(aStr[j].toString(), "td", BaseColor.BLACK, j == 0 ? firstColumnColor_ : rowColors_[i % 2], headBackgroundColor_, 0, 0.0f, 10.0f);
                    if (j == this.headDatas.length - 1) {
                        cell.setBorderWidthRight(1.0f);
                        cell.setBorderColorRight(headBackgroundColor_);
                    }
                    if (i == this.rowDatas.size() - 1) {
                        cell.setBorderWidthBottom(1.0f);
                        cell.setBorderColorBottom(headBackgroundColor_);
                    }
                    pTable.addCell(cell);
                }
            }
            this.document.add((Element)pTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PdfPCell addOneCell(String str, String type, BaseColor fontColor, BaseColor backColor, BaseColor borderColor, int style, float fixedHeight, float padding) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(str, new Font(this.baseFont, this.fontSize, style, fontColor)));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setBackgroundColor(backColor);
        if (fixedHeight != 0.0f) {
            cell.setFixedHeight(fixedHeight);
        }
        if (0.0f != padding) {
            cell.setPaddingTop(padding);
            cell.setPaddingBottom(padding);
        } else {
            cell.setPaddingBottom(5.0f);
        }
        cell.setLeading(1.0f, 1.2f);
        cell.setBorder(0);
        if ("td".equals(type)) {
            cell.setBorderWidthTop(1.0f);
            cell.setBorderColorTop(BaseColor.WHITE);
            cell.setBorderWidthLeft(1.0f);
            cell.setBorderColorLeft(borderColor);
        }
        return cell;
    }

    public TableLikeSevenAndAlternateLine setWidth(float width) {
        this.width = width;
        return this;
    }

    public TableLikeSevenAndAlternateLine setHeadDatas(String[] headDatas) {
        this.headDatas = headDatas;
        return this;
    }

    public TableLikeSevenAndAlternateLine setRowDatas(List<Object[]> rowDatas) {
        this.rowDatas = rowDatas;
        return this;
    }

    public TableLikeSevenAndAlternateLine setFirstColumnColor(int firstColumnColor) {
        this.firstColumnColor = firstColumnColor;
        return this;
    }

    public TableLikeSevenAndAlternateLine setRowColors(int[] rowColors) {
        this.rowColors = rowColors;
        return this;
    }

    public TableLikeSevenAndAlternateLine setHeadFontColor(int headFontColor) {
        this.headFontColor = headFontColor;
        return this;
    }

    public TableLikeSevenAndAlternateLine setHeadBackgroundColor(int headBackgroundColor) {
        this.headBackgroundColor = headBackgroundColor;
        return this;
    }

    public TableLikeSevenAndAlternateLine setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }
}

