/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.graphql.federation;

import com.expedia.graphql.federation.directives.FieldSet;
import com.expedia.graphql.federation.exception.InvalidFederatedSchema;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002JN\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JH\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\tH\u0002J:\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\"\u001a\u00020\u0012*\u00020#H\u0002J\f\u0010$\u001a\u00020\u0012*\u00020#H\u0002\u00a8\u0006%"}, d2={"Lcom/expedia/graphql/federation/FederatedSchemaValidator;", "", "()V", "validate", "", "federatedType", "", "fields", "", "Lgraphql/schema/GraphQLFieldDefinition;", "directives", "", "Lgraphql/schema/GraphQLDirective;", "validateDirective", "validatedType", "targetDirective", "fieldMap", "extendedType", "", "validateFieldSelection", "validatedDirective", "iterator", "", "errors", "", "validateGraphQLType", "type", "Lgraphql/schema/GraphQLType;", "validateKeySetField", "targetField", "validateProvidesDirective", "field", "validateRequiresDirective", "validatedField", "isExtendedType", "Lgraphql/schema/GraphQLDirectiveContainer;", "isFederatedType", "graphql-kotlin-federation"})
public final class FederatedSchemaValidator {
    public final void validateGraphQLType(@NotNull GraphQLType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll((GraphQLType)type);
        if (unwrappedType instanceof GraphQLObjectType && this.isFederatedType((GraphQLDirectiveContainer)unwrappedType)) {
            String string = ((GraphQLObjectType)unwrappedType).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unwrappedType.name");
            List list = ((GraphQLObjectType)unwrappedType).getFieldDefinitions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"unwrappedType.fieldDefinitions");
            Map map2 = ((GraphQLObjectType)unwrappedType).getDirectivesByName();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"unwrappedType.directivesByName");
            this.validate(string, list, map2);
        } else if (unwrappedType instanceof GraphQLInterfaceType && this.isFederatedType((GraphQLDirectiveContainer)unwrappedType)) {
            String string = ((GraphQLInterfaceType)unwrappedType).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unwrappedType.name");
            List list = ((GraphQLInterfaceType)unwrappedType).getFieldDefinitions();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"unwrappedType.fieldDefinitions");
            Map map3 = ((GraphQLInterfaceType)unwrappedType).getDirectivesByName();
            Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"unwrappedType.directivesByName");
            this.validate(string, list, map3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validate(String federatedType, List<? extends GraphQLFieldDefinition> fields, Map<String, ? extends GraphQLDirective> directives) {
        String string;
        Object object;
        void $this$associateByTo$iv$iv;
        boolean bl = false;
        List errors = new ArrayList();
        Iterable $this$associateBy$iv = fields;
        boolean bl2 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GraphQLFieldDefinition graphQLFieldDefinition = (GraphQLFieldDefinition)element$iv$iv;
            object = destination$iv$iv;
            boolean bl22 = false;
            string = it.getName();
            object.put(string, element$iv$iv);
        }
        Map fieldMap = destination$iv$iv;
        boolean extendedType = directives.containsKey("extends");
        errors.addAll((Collection)this.validateDirective(federatedType, "key", directives, fieldMap, extendedType));
        for (GraphQLFieldDefinition graphQLFieldDefinition : fields) {
            if (graphQLFieldDefinition.getDirective("requires") != null) {
                errors.addAll((Collection)this.validateRequiresDirective(federatedType, graphQLFieldDefinition, fieldMap, extendedType));
            }
            if (graphQLFieldDefinition.getDirective("provides") == null) continue;
            errors.addAll((Collection)this.validateProvidesDirective(federatedType, graphQLFieldDefinition));
        }
        if (!extendedType) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = fields;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GraphQLFieldDefinition it = (GraphQLFieldDefinition)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getDirective("external") != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GraphQLFieldDefinition it = (GraphQLFieldDefinition)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl4 = false;
                string = it.getName();
                object.add(string);
            }
            List list = (List)destination$iv$iv3;
            Collection collection = list;
            boolean bl5 = false;
            if (!collection.isEmpty()) {
                errors.add("base " + federatedType + " type has fields marked with @external directive, fields=" + list);
            }
        }
        Collection collection = errors;
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            throw (Throwable)((Object)new InvalidFederatedSchema(errors));
        }
    }

    private final List<String> validateRequiresDirective(String validatedType, GraphQLFieldDefinition validatedField, Map<String, ? extends GraphQLFieldDefinition> fieldMap, boolean extendedType) {
        boolean bl = false;
        List errors = new ArrayList();
        if (extendedType) {
            String string = validatedType + '.' + validatedField.getName();
            Map map2 = validatedField.getDirectivesByName();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"validatedField.directivesByName");
            errors.addAll((Collection)this.validateDirective(string, "requires", map2, fieldMap, extendedType));
        } else {
            errors.add("base " + validatedType + " type has fields marked with @requires directive, validatedField=" + validatedField.getName());
        }
        return errors;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> validateProvidesDirective(String federatedType, GraphQLFieldDefinition field) {
        boolean bl = false;
        List errors = new ArrayList();
        GraphQLUnmodifiedType returnType = GraphQLTypeUtil.unwrapAll((GraphQLType)((GraphQLType)field.getType()));
        if (returnType instanceof GraphQLObjectType) {
            if (!this.isExtendedType((GraphQLDirectiveContainer)returnType)) {
                errors.add("@provides directive is specified on a " + federatedType + '.' + field.getName() + " field references local object");
            } else {
                void $this$associateByTo$iv$iv;
                List list = ((GraphQLObjectType)returnType).getFieldDefinitions();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"returnType.fieldDefinitions");
                Iterable $this$associateBy$iv = list;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    GraphQLFieldDefinition graphQLFieldDefinition = (GraphQLFieldDefinition)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl2 = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    String string = v1.getName();
                    map2.put(string, element$iv$iv);
                }
                Map returnTypeFields = destination$iv$iv;
                String string = federatedType + '.' + field.getName();
                Map map3 = field.getDirectivesByName();
                Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"field.directivesByName");
                errors.addAll((Collection)this.validateDirective(string, "provides", map3, returnTypeFields, true));
            }
        } else {
            errors.add("@provides directive is specified on a " + federatedType + '.' + field.getName() + " field but it does not return an object type");
        }
        return errors;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> validateDirective(String validatedType, String targetDirective, Map<String, ? extends GraphQLDirective> directives, Map<String, ? extends GraphQLFieldDefinition> fieldMap, boolean extendedType) {
        boolean bl = false;
        List validationErrors = new ArrayList();
        GraphQLDirective directive = directives.get(targetDirective);
        if (directive == null) {
            validationErrors.add('@' + targetDirective + " directive is missing on federated " + validatedType + " type");
        } else {
            List fieldSet;
            List list;
            Iterable $this$filter$iv;
            GraphQLArgument graphQLArgument = directive.getArgument("fields");
            Object object = graphQLArgument != null ? graphQLArgument.getValue() : null;
            if (!(object instanceof FieldSet)) {
                object = null;
            }
            FieldSet fieldSet2 = (FieldSet)object;
            String fieldSetValue = fieldSet2 != null ? fieldSet2.value() : null;
            Object object2 = fieldSetValue;
            if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$filterTo$iv$iv;
                $this$filter$iv = (Iterable)object2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = it;
                    boolean bl3 = false;
                    if (!(charSequence.length() > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            $this$filter$iv = list;
            boolean bl4 = false;
            List list2 = $this$filter$iv;
            if (list2 == null) {
                list2 = fieldSet = CollectionsKt.emptyList();
            }
            if (fieldSet.isEmpty()) {
                validationErrors.add('@' + targetDirective + " directive on " + validatedType + " is missing field information");
            } else {
                String validatedDirectiveInfo = '@' + targetDirective + "(fields = " + fieldSetValue + ") directive on " + validatedType;
                this.validateFieldSelection(validatedDirectiveInfo, fieldSet.iterator(), fieldMap, extendedType, validationErrors);
            }
        }
        return validationErrors;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateFieldSelection(String validatedDirective, Iterator<String> iterator, Map<String, ? extends GraphQLFieldDefinition> fields, boolean extendedType, List<String> errors) {
        String previousField = null;
        while (iterator.hasNext()) {
            String currentField;
            switch (currentField = iterator.next()) {
                case "{": {
                    String string;
                    GraphQLFieldDefinition it;
                    Map map2;
                    Iterable $this$associateByTo$iv$iv;
                    boolean $i$f$associateByTo;
                    Map destination$iv$iv;
                    int capacity$iv;
                    boolean $i$f$associateBy;
                    FederatedSchemaValidator federatedSchemaValidator;
                    String string2;
                    Iterator<String> iterator2;
                    Map<String, ? extends GraphQLFieldDefinition> map3 = fields;
                    boolean bl = false;
                    GraphQLFieldDefinition graphQLFieldDefinition = map3.get(previousField);
                    GraphQLOutputType targetField = graphQLFieldDefinition != null ? graphQLFieldDefinition.getType() : null;
                    GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll((GraphQLType)((GraphQLType)targetField));
                    if (unwrappedType instanceof GraphQLInterfaceType) {
                        void $this$associateBy$iv;
                        List list = ((GraphQLInterfaceType)unwrappedType).getFieldDefinitions();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"unwrappedType.fieldDefinitions");
                        Iterable iterable = list;
                        iterator2 = iterator;
                        string2 = validatedDirective;
                        federatedSchemaValidator = this;
                        $i$f$associateBy = false;
                        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        void var14_16 = $this$associateBy$iv;
                        destination$iv$iv = new LinkedHashMap(capacity$iv);
                        $i$f$associateByTo = false;
                        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                            GraphQLFieldDefinition graphQLFieldDefinition2 = (GraphQLFieldDefinition)element$iv$iv;
                            map2 = destination$iv$iv;
                            boolean bl2 = false;
                            GraphQLFieldDefinition graphQLFieldDefinition3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)graphQLFieldDefinition3, (String)"it");
                            string = graphQLFieldDefinition3.getName();
                            map2.put(string, element$iv$iv);
                        }
                        map2 = destination$iv$iv;
                        federatedSchemaValidator.validateFieldSelection(string2, iterator2, map2, extendedType, errors);
                        break;
                    }
                    if (unwrappedType instanceof GraphQLObjectType) {
                        List list = ((GraphQLObjectType)unwrappedType).getFieldDefinitions();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"unwrappedType.fieldDefinitions");
                        Iterable $this$associateBy$iv = list;
                        iterator2 = iterator;
                        string2 = validatedDirective;
                        federatedSchemaValidator = this;
                        $i$f$associateBy = false;
                        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        $this$associateByTo$iv$iv = $this$associateBy$iv;
                        destination$iv$iv = new LinkedHashMap(capacity$iv);
                        $i$f$associateByTo = false;
                        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                            it = (GraphQLFieldDefinition)element$iv$iv;
                            map2 = destination$iv$iv;
                            boolean bl3 = false;
                            GraphQLFieldDefinition graphQLFieldDefinition4 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)graphQLFieldDefinition4, (String)"it");
                            string = graphQLFieldDefinition4.getName();
                            map2.put(string, element$iv$iv);
                        }
                        map2 = destination$iv$iv;
                        federatedSchemaValidator.validateFieldSelection(string2, iterator2, map2, extendedType, errors);
                        break;
                    }
                    errors.add(validatedDirective + " specifies invalid field set - field set defines nested selection set on unsupported type");
                    break;
                }
                case "}": {
                    return;
                }
                default: {
                    this.validateKeySetField(fields.get(currentField), extendedType, errors, validatedDirective);
                }
            }
            previousField = currentField;
        }
    }

    private final void validateKeySetField(GraphQLFieldDefinition targetField, boolean extendedType, List<String> errors, String validatedDirective) {
        if (targetField != null) {
            boolean externalField;
            boolean bl = externalField = targetField.getDirective("external") != null;
            if (extendedType && !externalField) {
                errors.add(validatedDirective + " specifies invalid field set - extended type incorrectly references local field=" + targetField.getName());
            } else if (!extendedType && externalField) {
                errors.add(validatedDirective + " specifies invalid field set - type incorrectly references external field=" + targetField.getName());
            }
            GraphQLType graphQLType = GraphQLTypeUtil.unwrapNonNull((GraphQLType)((GraphQLType)targetField.getType()));
            if (graphQLType instanceof GraphQLList) {
                errors.add(validatedDirective + " specifies invalid field set - field set references GraphQLList, field=" + targetField.getName());
            } else if (graphQLType instanceof GraphQLInterfaceType) {
                errors.add(validatedDirective + " specifies invalid field set - field set references GraphQLInterfaceType, field=" + targetField.getName());
            } else if (graphQLType instanceof GraphQLUnionType) {
                errors.add(validatedDirective + " specifies invalid field set - field set references GraphQLUnionType, field=" + targetField.getName());
            }
        } else {
            errors.add(validatedDirective + " specifies invalid field set - field set specifies fields that do not exist");
        }
    }

    private final boolean isFederatedType(@NotNull GraphQLDirectiveContainer $this$isFederatedType) {
        return $this$isFederatedType.getDirective("key") != null || this.isExtendedType($this$isFederatedType);
    }

    private final boolean isExtendedType(@NotNull GraphQLDirectiveContainer $this$isExtendedType) {
        return $this$isExtendedType.getDirective("extends") != null;
    }
}

