/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.client.metrics;

import com.expedia.www.haystack.client.metrics.MetricsRegistry;
import com.expedia.www.haystack.client.metrics.Tag;
import java.util.ArrayList;
import java.util.Collection;

public interface Counter {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    default public void increment() {
        this.increment(1.0);
    }

    public void increment(double var1);

    default public void decrement() {
        this.decrement(1.0);
    }

    public void decrement(double var1);

    public double count();

    public static class Builder {
        private final String name;
        private final Collection<Tag> tags = new ArrayList<Tag>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder tags(Collection<Tag> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder tag(Tag tag) {
            this.tags.add(tag);
            return this;
        }

        public Counter register(MetricsRegistry registry) {
            return registry.counter(this.name, this.tags);
        }
    }
}

