/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.client.metrics;

import com.expedia.www.haystack.client.metrics.Counter;
import com.expedia.www.haystack.client.metrics.Gauge;
import com.expedia.www.haystack.client.metrics.MetricsRegistry;
import com.expedia.www.haystack.client.metrics.Tag;
import com.expedia.www.haystack.client.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.ToDoubleFunction;

public class Metrics
implements MetricsRegistry {
    private final MetricsRegistry registry;
    private final Collection<Tag> commonTags;
    private final String baseName;

    public Metrics(MetricsRegistry registry, String baseName, Collection<Tag> commonTags) {
        this.registry = registry;
        this.baseName = baseName;
        this.commonTags = Collections.unmodifiableCollection(commonTags);
    }

    public Metrics(MetricsRegistry registry) {
        this(registry, "", Collections.emptyList());
    }

    protected Collection<Tag> combineTags(Collection<Tag> tags) {
        ArrayList<Tag> combinedTags = new ArrayList<Tag>(this.commonTags);
        combinedTags.addAll(tags);
        return combinedTags;
    }

    protected String formatName(String name) {
        return String.format("%s.%s", this.baseName, name);
    }

    @Override
    public <T> Gauge gauge(String name, T obj, ToDoubleFunction<T> f) {
        return this.gauge(name, this.commonTags, obj, f);
    }

    @Override
    public <T> Gauge gauge(String name, Collection<Tag> tags, T obj, ToDoubleFunction<T> f) {
        return this.registry.gauge(this.formatName(name), this.combineTags(tags), obj, f);
    }

    @Override
    public Counter counter(String name) {
        return this.counter(name, this.commonTags);
    }

    @Override
    public Counter counter(String name, Collection<Tag> tags) {
        return this.registry.counter(this.formatName(name), this.combineTags(tags));
    }

    @Override
    public Timer timer(String name) {
        return this.timer(name, this.commonTags);
    }

    @Override
    public Timer timer(String name, Collection<Tag> tags) {
        return this.registry.timer(this.formatName(name), this.combineTags(tags));
    }
}

