/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.client.metrics;

import com.expedia.www.haystack.client.metrics.MetricsRegistry;
import com.expedia.www.haystack.client.metrics.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface Timer {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    default public void record(long duration) {
        this.record(duration, TimeUnit.NANOSECONDS);
    }

    public void record(long var1, TimeUnit var3);

    public double totalTime(TimeUnit var1);

    public long count();

    public Sample start();

    public static class Builder {
        private final String name;
        private final Collection<Tag> tags = new ArrayList<Tag>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder tags(Collection<Tag> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder tag(Tag tag) {
            this.tags.add(tag);
            return this;
        }

        public Timer register(MetricsRegistry registry) {
            return registry.timer(this.name, this.tags);
        }
    }

    public static interface Sample
    extends AutoCloseable {
        @Override
        default public void close() {
            this.stop();
        }

        public long stop();
    }
}

