/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.metrics.appenders.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.expedia.www.haystack.metrics.GraphiteConfig;
import com.expedia.www.haystack.metrics.GraphiteConfigImpl;
import com.expedia.www.haystack.metrics.MetricObjects;
import com.expedia.www.haystack.metrics.MetricPublishing;
import com.expedia.www.haystack.metrics.appenders.logback.StartUpMetric;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.util.VisibleForTesting;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;

public class EmitToGraphiteLogbackAppender
extends AppenderBase<ILoggingEvent> {
    @VisibleForTesting
    static final String ERRORS_METRIC_GROUP = "errors";
    @VisibleForTesting
    static final Map<String, Counter> ERRORS_COUNTERS = new ConcurrentHashMap<String, Counter>();
    private final MetricPublishing metricPublishing;
    private final MetricObjects metricObjects;
    private final Factory factory;
    private String host = "haystack.local";
    private String subsystem;
    private boolean enabled = true;
    private int port = 2003;
    private int pollintervalseconds = 60;
    private int queuesize = 10;
    private boolean sendasrate = false;
    private StartUpMetric startUpMetric;

    public EmitToGraphiteLogbackAppender() {
        this(new MetricPublishing(), new MetricObjects(), new Factory());
    }

    @VisibleForTesting
    EmitToGraphiteLogbackAppender(MetricPublishing metricPublishing, MetricObjects metricObjects, Factory factory) {
        this.metricPublishing = metricPublishing;
        this.metricObjects = metricObjects;
        this.factory = factory;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPollintervalseconds(int pollintervalseconds) {
        this.pollintervalseconds = pollintervalseconds;
    }

    public void setQueuesize(int queuesize) {
        this.queuesize = queuesize;
    }

    public void setSendasrate(boolean sendasrate) {
        this.sendasrate = sendasrate;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public void start() {
        super.start();
        if (this.enabled) {
            this.metricPublishing.start((GraphiteConfig)new GraphiteConfigImpl(this.host, this.port, this.pollintervalseconds, this.queuesize, this.sendasrate));
        }
        this.startUpMetric = this.factory.createStartUpMetric(this.metricObjects, this.subsystem, new Timer());
        this.startUpMetric.start();
    }

    public void stop() {
        if (this.enabled) {
            this.metricPublishing.stop();
        }
        if (this.startUpMetric != null) {
            this.startUpMetric.stop();
        }
        super.stop();
    }

    protected void append(ILoggingEvent logEvent) {
        Level level = logEvent.getLevel();
        if (this.isLevelSevereEnoughToCount(level)) {
            StackTraceElement[] stackTraceElements = logEvent.getCallerData();
            StackTraceElement stackTraceElement = stackTraceElements[0];
            this.getCounter(level, stackTraceElement).increment();
        }
    }

    @VisibleForTesting
    boolean isLevelSevereEnoughToCount(Level level) {
        return level == Level.ERROR;
    }

    @VisibleForTesting
    Counter getCounter(Level level, StackTraceElement stackTraceElement) {
        String fullyQualifiedClassName = EmitToGraphiteLogbackAppender.changePeriodsToDashes(stackTraceElement.getClassName());
        String key = fullyQualifiedClassName;
        if (!ERRORS_COUNTERS.containsKey(key)) {
            Counter counter = this.factory.createCounter(this.metricObjects, this.subsystem, fullyQualifiedClassName, level.toString());
            ERRORS_COUNTERS.putIfAbsent(key, counter);
        }
        return ERRORS_COUNTERS.get(key);
    }

    static String changePeriodsToDashes(String fullyQualifiedClassName) {
        return fullyQualifiedClassName.replace('.', '-');
    }

    @VisibleForTesting
    static class Factory {
        Factory() {
        }

        Counter createCounter(MetricObjects metricObjects, String subsystem, String fullyQualifiedClassName, String counterName) {
            return metricObjects.createAndRegisterResettingCounter(EmitToGraphiteLogbackAppender.ERRORS_METRIC_GROUP, subsystem, fullyQualifiedClassName, counterName);
        }

        StartUpMetric createStartUpMetric(MetricObjects metricObjects, String subsystem, Timer timer) {
            return new StartUpMetric(timer, new StartUpMetric.Factory(), metricObjects, subsystem);
        }
    }
}

