/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.metrics.appenders.logback;

import ch.qos.logback.classic.Level;
import com.expedia.www.haystack.metrics.MetricObjects;
import com.expedia.www.haystack.metrics.appenders.logback.EmitToGraphiteLogbackAppender;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.util.VisibleForTesting;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

class StartUpMetric {
    private static final int METRIC_VALUE = 0;
    private static final long INITIAL_DELAY_MILLIS = 0L;
    private static final int INTERVAL_MINUTES = 5;
    private static final String FULLY_QUALIFIED_CLASS_NAME = EmitToGraphiteLogbackAppender.changePeriodsToDashes(StartUpMetric.class.getName());
    private final Timer timer;
    private final Counter counter;

    StartUpMetric(Timer timer, Factory factory, MetricObjects metricObjects, String subsystem) {
        this.timer = timer;
        this.counter = factory.createCounter(metricObjects, subsystem);
    }

    void start() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                StartUpMetric.this.emit();
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
    }

    void stop() {
        this.timer.cancel();
    }

    private void emit() {
        this.counter.increment(0L);
    }

    @VisibleForTesting
    static class Factory {
        Factory() {
        }

        Counter createCounter(MetricObjects metricObjects, String subsystem) {
            return metricObjects.createAndRegisterResettingCounter("errors", subsystem, FULLY_QUALIFIED_CLASS_NAME, Level.ERROR.toString());
        }
    }
}

