/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.remote.clients;

import com.expedia.open.tracing.agent.api.DispatchResult;
import com.expedia.open.tracing.agent.api.SpanAgentGrpc;
import com.expedia.www.haystack.client.metrics.Counter;
import com.expedia.www.haystack.client.metrics.Metrics;
import com.expedia.www.haystack.client.metrics.MetricsRegistry;
import com.expedia.www.haystack.client.metrics.Tag;
import com.expedia.www.haystack.client.metrics.Timer;
import com.expedia.www.haystack.remote.clients.Client;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGrpcClient<R>
implements Client<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseGrpcClient.class);
    protected final ManagedChannel channel;
    protected final SpanAgentGrpc.SpanAgentStub stub;
    protected final long shutdownTimeoutMS;
    protected final StreamObserver<DispatchResult> observer;
    protected final Timer sendTimer;
    protected final Counter sendExceptionCounter;
    protected final Timer closeTimer;
    protected final Counter closeTimeoutCounter;
    protected final Counter closeInterruptedCounter;
    protected final Counter closeExceptionCounter;
    protected final Counter flushCounter;

    public BaseGrpcClient(Metrics metrics, ManagedChannel channel, SpanAgentGrpc.SpanAgentStub stub, StreamObserver<DispatchResult> observer, long shutdownTimeoutMS) {
        this.channel = channel;
        this.stub = stub;
        this.shutdownTimeoutMS = shutdownTimeoutMS;
        this.observer = observer;
        this.sendTimer = Timer.builder((String)"send").register((MetricsRegistry)metrics);
        this.sendExceptionCounter = Counter.builder((String)"send").tag(new Tag("state", "exception")).register((MetricsRegistry)metrics);
        this.closeTimer = Timer.builder((String)"close").register((MetricsRegistry)metrics);
        this.closeTimeoutCounter = Counter.builder((String)"close").tag(new Tag("state", "timeout")).register((MetricsRegistry)metrics);
        this.closeInterruptedCounter = Counter.builder((String)"close").tag(new Tag("state", "interrupted")).register((MetricsRegistry)metrics);
        this.closeExceptionCounter = Counter.builder((String)"close").tag(new Tag("state", "exception")).register((MetricsRegistry)metrics);
        this.flushCounter = Counter.builder((String)"flush").register((MetricsRegistry)metrics);
    }

    @Override
    public void close() {
        try (Timer.Sample timer = this.closeTimer.start();){
            this.channel.shutdown();
            try {
                if (!this.channel.awaitTermination(this.shutdownTimeoutMS, TimeUnit.SECONDS)) {
                    this.channel.shutdownNow();
                    this.closeTimeoutCounter.increment();
                    LOGGER.warn("Channel failed to terminate, forcibly closing it.");
                    if (!this.channel.awaitTermination(this.shutdownTimeoutMS, TimeUnit.SECONDS)) {
                        this.closeTimeoutCounter.increment();
                        LOGGER.error("Channel failed to terminate.");
                    }
                }
            }
            catch (InterruptedException e) {
                this.closeInterruptedCounter.increment();
                LOGGER.error("Unable to close the channel.", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.closeExceptionCounter.increment();
            LOGGER.error("Unexpected exception caught on client shutdown.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void flush() {
        this.flushCounter.increment();
    }

    public static abstract class Builder {
        protected StreamObserver<DispatchResult> observer;
        protected Metrics metrics;
        protected String host;
        protected int port;
        protected long keepAliveTimeMS = TimeUnit.SECONDS.toMillis(30L);
        protected long keepAliveTimeoutMS = TimeUnit.SECONDS.toMillis(30L);
        protected boolean keepAliveWithoutCalls = true;
        protected NegotiationType negotiationType = NegotiationType.PLAINTEXT;
        protected ManagedChannel channel;
        protected long shutdownTimeoutMS = TimeUnit.SECONDS.toMillis(30L);

        private Builder(MetricsRegistry registry) {
            this(new Metrics(registry, Client.class.getName(), Arrays.asList(new Tag("type", "grpc"))));
        }

        private Builder(Metrics metrics) {
            this.observer = new GRPCAgentClientStreamObserver(metrics);
            this.metrics = metrics;
        }

        public Builder(MetricsRegistry metrics, ManagedChannel channel) {
            this(metrics);
            this.channel = channel;
        }

        public Builder(Metrics metrics, ManagedChannel channel) {
            this(metrics);
            this.channel = channel;
        }

        public Builder(MetricsRegistry metrics, String host, int port) {
            this(metrics);
            this.host = host;
            this.port = port;
        }

        public Builder(Metrics metrics, String host, int port) {
            this(metrics);
            this.host = host;
            this.port = port;
        }

        public Builder withObserver(StreamObserver<DispatchResult> observer) {
            this.observer = observer;
            return this;
        }

        public Builder withKeepAliveTimeMS(long keepAliveTimeMS) {
            this.keepAliveTimeMS = keepAliveTimeMS;
            return this;
        }

        public Builder withKeepAliveTimeoutMS(long keepAliveTimeoutMS) {
            this.keepAliveTimeoutMS = keepAliveTimeoutMS;
            return this;
        }

        public Builder withKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            return this;
        }

        public Builder withNegotiationType(NegotiationType negotiationType) {
            this.negotiationType = negotiationType;
            return this;
        }

        public Builder withShutdownTimeoutMS(long shutdownTimeoutMS) {
            this.shutdownTimeoutMS = shutdownTimeoutMS;
            return this;
        }

        protected ManagedChannel buildManagedChannel() {
            return NettyChannelBuilder.forAddress((String)this.host, (int)this.port).keepAliveTime(this.keepAliveTimeMS, TimeUnit.MILLISECONDS).keepAliveTimeout(this.keepAliveTimeoutMS, TimeUnit.MILLISECONDS).keepAliveWithoutCalls(this.keepAliveWithoutCalls).negotiationType(this.negotiationType).build();
        }

        public abstract BaseGrpcClient build();
    }

    public static class GRPCAgentClientStreamObserver
    implements StreamObserver<DispatchResult> {
        private Counter onCompletedCounter;
        private Counter onErrorCounter;
        private Counter ratelimitCounter;
        private Counter unknownCounter;
        private Counter badresultCounter;

        public GRPCAgentClientStreamObserver(Metrics metrics) {
            this.onCompletedCounter = Counter.builder((String)"observer").tag(new Tag("state", "completed")).register((MetricsRegistry)metrics);
            this.onErrorCounter = Counter.builder((String)"observer").tag(new Tag("state", "error")).register((MetricsRegistry)metrics);
            this.ratelimitCounter = Counter.builder((String)"observer").tag(new Tag("state", "ratelimited")).register((MetricsRegistry)metrics);
            this.unknownCounter = Counter.builder((String)"observer").tag(new Tag("state", "unknown")).register((MetricsRegistry)metrics);
            this.badresultCounter = Counter.builder((String)"observer").tag(new Tag("state", "badresult")).register((MetricsRegistry)metrics);
        }

        public void onCompleted() {
            this.onCompletedCounter.increment();
            LOGGER.debug("Dispatching span completed");
        }

        public void onError(Throwable t) {
            this.onErrorCounter.increment();
            LOGGER.error("Dispatching span failed with error: " + t, t);
        }

        public void onNext(DispatchResult value) {
            switch (value.getCode()) {
                case SUCCESS: {
                    break;
                }
                case RATE_LIMIT_ERROR: {
                    this.ratelimitCounter.increment();
                    LOGGER.error("Rate limit error received from agent");
                    break;
                }
                case UNKNOWN_ERROR: {
                    this.unknownCounter.increment();
                    LOGGER.error("Unknown error received from agent");
                    break;
                }
                default: {
                    this.badresultCounter.increment();
                    LOGGER.error("Unknown result received from agent: {}", (Object)value.getCode());
                }
            }
        }
    }
}

