/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.remote.clients;

import com.expedia.www.haystack.remote.clients.ClientException;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public abstract class BaseHttpClient {
    private final String endpoint;
    private final BasicHeader[] headers;
    private final CloseableHttpClient httpClient;

    public BaseHttpClient(String endpoint, Map<String, String> headers) {
        this(endpoint, headers, HttpClients.createDefault());
    }

    public BaseHttpClient(String endpoint) {
        this(endpoint, new HashMap<String, String>());
    }

    public BaseHttpClient(String endpoint, Map<String, String> headers, CloseableHttpClient httpClient) {
        Validate.notEmpty((CharSequence)endpoint, (String)"Haystack collector endpoint can't be empty", (Object[])new Object[0]);
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.headers = headers.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).toArray(new BasicHeader[0]);
    }

    public void close() throws ClientException {
        this.closeQuietly((Closeable)this.httpClient);
    }

    public void flush() throws ClientException {
    }

    public boolean send(byte[] spanBytes) throws ClientException {
        HttpPost post = new HttpPost(this.endpoint);
        if (this.headers != null && this.headers.length > 0) {
            post.setHeaders((Header[])this.headers);
        }
        ByteArrayEntity entity = new ByteArrayEntity(spanBytes);
        entity.setContentType("application/octet-stream");
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = this.getStatusCode(response);
            if (this.is2xx(statusCode)) {
                boolean bl = true;
                return bl;
            }
            try {
                throw new ClientException(String.format("Failed sending span to http collector endpoint=%s, http status code=%d", this.endpoint, statusCode));
            }
            catch (IOException e) {
                throw new ClientException(String.format("Failed sending span to http collector endpoint=%s", this.endpoint), e);
            }
        }
        finally {
            this.closeQuietly((Closeable)response);
        }
    }

    private int getStatusCode(CloseableHttpResponse response) {
        return response.getStatusLine() == null ? 0 : response.getStatusLine().getStatusCode();
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    private void closeQuietly(Closeable obj) {
        try {
            obj.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

