/*
 * Decompiled with CFR 0.152.
 */
package com.expedia.www.haystack.remote.clients;

import com.expedia.open.tracing.Span;
import com.expedia.open.tracing.agent.api.DispatchResult;
import com.expedia.open.tracing.agent.api.SpanAgentGrpc;
import com.expedia.www.haystack.client.metrics.Metrics;
import com.expedia.www.haystack.client.metrics.MetricsRegistry;
import com.expedia.www.haystack.client.metrics.Timer;
import com.expedia.www.haystack.remote.clients.BaseGrpcClient;
import com.expedia.www.haystack.remote.clients.ClientException;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;

public class GRPCAgentProtoClient
extends BaseGrpcClient<Span> {
    public GRPCAgentProtoClient(Metrics metrics, ManagedChannel channel, SpanAgentGrpc.SpanAgentStub stub, StreamObserver<DispatchResult> observer, long shutdownTimeoutMS) {
        super(metrics, channel, stub, observer, shutdownTimeoutMS);
    }

    @Override
    public boolean send(Span span) throws ClientException {
        try (Timer.Sample timer = this.sendTimer.start();){
            this.stub.dispatch(span, this.observer);
        }
        catch (Exception e) {
            this.sendExceptionCounter.increment();
            throw new ClientException(e.getMessage(), e);
        }
        return true;
    }

    public static final class Builder
    extends BaseGrpcClient.Builder {
        public Builder(MetricsRegistry metrics, ManagedChannel channel) {
            super(metrics, channel);
        }

        public Builder(Metrics metrics, String host, int port) {
            super(metrics, host, port);
        }

        public Builder(MetricsRegistry metrics, String host, int port) {
            super(metrics, host, port);
        }

        @Override
        public GRPCAgentProtoClient build() {
            ManagedChannel managedChannel = this.channel;
            if (managedChannel == null) {
                managedChannel = this.buildManagedChannel();
            }
            SpanAgentGrpc.SpanAgentStub stub = SpanAgentGrpc.newStub((Channel)managedChannel);
            return new GRPCAgentProtoClient(this.metrics, managedChannel, stub, (StreamObserver<DispatchResult>)this.observer, this.shutdownTimeoutMS);
        }
    }
}

