/*
 * Decompiled with CFR 0.152.
 */
package brave.blobs;

import brave.Span;
import com.expedia.blobs.core.BlobContext;
import com.expedia.blobs.core.BlobType;
import org.apache.commons.lang3.Validate;

public class SpanBlobContext
implements BlobContext {
    private final Span span;
    private final String remoteServiceName;
    private static final String PARTIAL_BLOB_KEY = "-blob";
    private final String name;

    public SpanBlobContext(Span span, String remoteServiceName, String name) {
        Validate.notNull((Object)span, (String)"span cannot be null in context", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)remoteServiceName, (String)"remoteServiceName name cannot be null or empty in context", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)name, (String)"name cannot be null or empty in context", (Object[])new Object[0]);
        this.span = span;
        this.remoteServiceName = remoteServiceName;
        this.name = name;
    }

    public String getOperationName() {
        return this.name;
    }

    public String getServiceName() {
        return this.remoteServiceName;
    }

    public String getOperationId() {
        return String.valueOf(this.span.context().spanId());
    }

    public void onBlobKeyCreate(String blobKey, BlobType blobType) {
        this.span.tag(String.format("%s%s", blobType.getType(), PARTIAL_BLOB_KEY), blobKey);
    }
}

