/*
 * Decompiled with CFR 0.152.
 */
package com.experoinc.dropwizard.tinkerpop;

import com.codahale.metrics.health.HealthCheck;
import com.experoinc.dropwizard.tinkerpop.TinkerPopHealthCheck;
import com.experoinc.dropwizard.tinkerpop.TinkerPopManaged;
import com.experoinc.dropwizard.tinkerpop.auth.AuthFactory;
import com.experoinc.dropwizard.tinkerpop.serializers.GryoMessageSerializerV1d0Factory;
import com.experoinc.dropwizard.tinkerpop.serializers.MessageSerializerFactory;
import com.experoinc.dropwizard.tinkerpop.ssl.SslConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.tinkerpop.gremlin.driver.AuthProperties;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.hibernate.validator.constraints.NotEmpty;

public class TinkerPopFactory {
    private static final int DEFAULT_PORT = 8182;
    @NotEmpty
    private String[] contactPoints;
    @Min(value=1L)
    private int port = 8182;
    @Valid
    private MessageSerializerFactory serializer = new GryoMessageSerializerV1d0Factory();
    @Min(value=1L)
    private int nioPoolSize = Runtime.getRuntime().availableProcessors();
    @Min(value=1L)
    private int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    @Min(value=1L)
    private int minConnectionPoolSize = 2;
    @Min(value=1L)
    private int maxConnectionPoolSize = 8;
    @Min(value=1L)
    private int minSimultaneousUsagePerConnection = 8;
    @Min(value=1L)
    private int maxSimultaneousUsagePerConnection = 16;
    @Min(value=1L)
    private int maxInProcessPerConnection = 4;
    @Min(value=1L)
    private int minInProcessPerConnection = 1;
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration maxWaitForConnection = Duration.milliseconds((long)3000L);
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration maxWaitForSessionClose = Duration.milliseconds((long)3000L);
    @Min(value=1L)
    private int maxContentLength = 65536;
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration reconnectInterval = Duration.milliseconds((long)1000L);
    @Min(value=1L)
    private int resultIterationBatchSize = 64;
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration keepAliveInterval = Duration.minutes((long)30L);
    @NotEmpty
    private String channelizer = Channelizer.WebSocketChannelizer.class.getName();
    @Valid
    private Optional<AuthFactory> authFactory = Optional.empty();
    @NotNull
    @Valid
    private SslConfiguration ssl = new SslConfiguration();
    @NotEmpty
    private String validationQuery = "g.V().hasNext()";
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration validationQueryTimeout = Duration.seconds((long)10L);
    @NotNull
    private Duration shutdownTimeout = Duration.seconds((long)60L);

    @JsonProperty
    public String[] getContactPoints() {
        return this.contactPoints;
    }

    @JsonProperty
    public void setContactPoints(String[] contactPoints) {
        this.contactPoints = contactPoints;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public MessageSerializerFactory getSerializer() {
        return this.serializer;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @JsonProperty
    public void setShutdownTimeout(Duration shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    @JsonProperty
    public void setSerializer(MessageSerializerFactory serializer) {
        this.serializer = serializer;
    }

    @JsonProperty
    public int getNioPoolSize() {
        return this.nioPoolSize;
    }

    @JsonProperty
    public void setNioPoolSize(int nioPoolSize) {
        this.nioPoolSize = nioPoolSize;
    }

    @JsonProperty
    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    @JsonProperty
    public void setWorkerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
    }

    @JsonProperty
    public int getMinConnectionPoolSize() {
        return this.minConnectionPoolSize;
    }

    @JsonProperty
    public void setMinConnectionPoolSize(int minConnectionPoolSize) {
        this.minConnectionPoolSize = minConnectionPoolSize;
    }

    @JsonProperty
    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    @JsonProperty
    public void setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
    }

    @JsonProperty
    public int getMinSimultaneousUsagePerConnection() {
        return this.minSimultaneousUsagePerConnection;
    }

    @JsonProperty
    public void setMinSimultaneousUsagePerConnection(int minSimultaneousUsagePerConnection) {
        this.minSimultaneousUsagePerConnection = minSimultaneousUsagePerConnection;
    }

    @JsonProperty
    public int getMaxSimultaneousUsagePerConnection() {
        return this.maxSimultaneousUsagePerConnection;
    }

    @JsonProperty
    public void setMaxSimultaneousUsagePerConnection(int maxSimultaneousUsagePerConnection) {
        this.maxSimultaneousUsagePerConnection = maxSimultaneousUsagePerConnection;
    }

    @JsonProperty
    public int getMaxInProcessPerConnection() {
        return this.maxInProcessPerConnection;
    }

    @JsonProperty
    public void setMaxInProcessPerConnection(int maxInProcessPerConnection) {
        this.maxInProcessPerConnection = maxInProcessPerConnection;
    }

    @JsonProperty
    public int getMinInProcessPerConnection() {
        return this.minInProcessPerConnection;
    }

    @JsonProperty
    public void setMinInProcessPerConnection(int minInProcessPerConnection) {
        this.minInProcessPerConnection = minInProcessPerConnection;
    }

    @JsonProperty
    public Duration getMaxWaitForConnection() {
        return this.maxWaitForConnection;
    }

    @JsonProperty
    public void setMaxWaitForConnection(Duration maxWaitForConnection) {
        this.maxWaitForConnection = maxWaitForConnection;
    }

    @JsonProperty
    public Duration getMaxWaitForSessionClose() {
        return this.maxWaitForSessionClose;
    }

    @JsonProperty
    public void setMaxWaitForSessionClose(Duration maxWaitForSessionClose) {
        this.maxWaitForSessionClose = maxWaitForSessionClose;
    }

    @JsonProperty
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @JsonProperty
    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @JsonProperty
    public Duration getReconnectInterval() {
        return this.reconnectInterval;
    }

    @JsonProperty
    public void setReconnectInterval(Duration reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    @JsonProperty
    public int getResultIterationBatchSize() {
        return this.resultIterationBatchSize;
    }

    @JsonProperty
    public void setResultIterationBatchSize(int resultIterationBatchSize) {
        this.resultIterationBatchSize = resultIterationBatchSize;
    }

    @JsonProperty
    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    @JsonProperty
    public void setKeepAliveInterval(Duration keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    @JsonProperty
    public String getChannelizer() {
        return this.channelizer;
    }

    @JsonProperty
    public void setChannelizer(String channelizer) {
        this.channelizer = channelizer;
    }

    @JsonProperty(value="auth")
    public Optional<AuthFactory> getAuthFactory() {
        return this.authFactory;
    }

    @JsonProperty(value="auth")
    public void setAuthFactory(Optional<AuthFactory> authFactory) {
        this.authFactory = authFactory;
    }

    @JsonProperty
    public SslConfiguration getSsl() {
        return this.ssl;
    }

    @JsonProperty
    public void setSsl(SslConfiguration ssl) {
        this.ssl = ssl;
    }

    @JsonProperty
    public String getValidationQuery() {
        return this.validationQuery;
    }

    @JsonProperty
    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    @JsonProperty
    public Duration getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    @JsonProperty
    public void setValidationQueryTimeout(Duration validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    protected Cluster build() {
        Cluster.Builder builder = Cluster.build().addContactPoints(this.contactPoints).port(this.port).serializer(this.serializer.build()).authProperties((AuthProperties)this.authFactory.map(af -> af.build()).orElse(null)).channelizer(this.channelizer).enableSsl(this.ssl.isEnabled()).keyCertChainFile(this.ssl.getKeyCertChainFile()).keyFile(this.ssl.getKeyFile()).keyPassword(this.ssl.getKeyPassword()).trustCertificateChainFile(this.ssl.getTrustCertChainFile()).nioPoolSize(this.nioPoolSize).workerPoolSize(this.workerPoolSize).maxConnectionPoolSize(this.maxConnectionPoolSize).maxWaitForConnection((int)this.maxWaitForConnection.toMilliseconds()).maxWaitForSessionClose((int)this.maxWaitForSessionClose.toMilliseconds()).maxInProcessPerConnection(this.maxInProcessPerConnection).maxSimultaneousUsagePerConnection(this.maxSimultaneousUsagePerConnection).keepAliveInterval(this.keepAliveInterval.toMilliseconds()).reconnectInterval((int)this.reconnectInterval.toMilliseconds()).resultIterationBatchSize(this.resultIterationBatchSize).maxContentLength(this.maxContentLength);
        Cluster cluster = builder.create();
        return cluster;
    }

    @JsonIgnore
    public Cluster build(Environment environment) {
        Cluster cluster = this.build();
        environment.lifecycle().manage((Managed)new TinkerPopManaged(cluster, this.getShutdownTimeout()));
        environment.healthChecks().register("tinkerpop", (HealthCheck)new TinkerPopHealthCheck(cluster, this.validationQuery, this.validationQueryTimeout));
        return cluster;
    }
}

