/*
 * Decompiled with CFR 0.152.
 */
package com.experoinc.dropwizard.tinkerpop;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.util.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinkerPopHealthCheck
extends HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinkerPopHealthCheck.class);
    private final Client client;
    private final String validationGremlinQuery;
    private final Duration validationTimeout;

    public TinkerPopHealthCheck(Cluster cluster, String validationGremlinQuery, Duration validationTimeout) {
        this.client = cluster.connect();
        this.validationGremlinQuery = validationGremlinQuery;
        this.validationTimeout = validationTimeout;
    }

    protected HealthCheck.Result check() throws Exception {
        try {
            CompletableFuture future = this.client.submitAsync(this.validationGremlinQuery);
            ResultSet result = (ResultSet)future.get(this.validationTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            return HealthCheck.Result.healthy();
        }
        catch (TimeoutException ex) {
            String msg = String.format("Validation query was unable to complete after %d ms", this.validationTimeout.toMilliseconds());
            LOGGER.error(msg);
            return HealthCheck.Result.unhealthy((String)msg);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to execute tinker pop health check", (Throwable)ex);
            return HealthCheck.Result.unhealthy((String)ex.getMessage());
        }
    }
}

