/*
 * Decompiled with CFR 0.152.
 */
package com.experoinc.dropwizard.tinkerpop;

import io.dropwizard.lifecycle.Managed;
import io.dropwizard.util.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinkerPopManaged
implements Managed {
    private static final Logger LOG = LoggerFactory.getLogger(TinkerPopManaged.class);
    private final Cluster cluster;
    private final Duration shutdownTimeout;

    public TinkerPopManaged(Cluster cluster, Duration shutdownTimeout) {
        this.cluster = cluster;
        this.shutdownTimeout = shutdownTimeout;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        LOG.info("Attempting to shutdown TinkerPop cluster connection.");
        CompletableFuture future = this.cluster.closeAsync();
        try {
            future.get(this.shutdownTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            LOG.warn("Unable to close TinkerPop cluster after {}", (Object)this.shutdownTimeout);
        }
    }
}

