/*
 * Decompiled with CFR 0.152.
 */
package com.experoinc.dropwizard.tinkerpop.serializers;

import com.experoinc.dropwizard.tinkerpop.serializers.MessageSerializerFactory;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;

@JsonTypeName(value="gryoMessageSerializerV1d0")
public class GryoMessageSerializerV1d0Factory
implements MessageSerializerFactory {
    private boolean serializeResultToString = false;
    @Min(value=1L)
    private int bufferSize = 4096;
    @NotNull
    private List<String> ioRegistries = Collections.emptyList();
    @NotNull
    private List<String> customClasses = Collections.emptyList();
    private Optional<String> classResolverSupplier = Optional.empty();

    @JsonProperty
    public boolean isSerializeResultToString() {
        return this.serializeResultToString;
    }

    @JsonProperty
    public void setSerializeResultToString(boolean serializeResultToString) {
        this.serializeResultToString = serializeResultToString;
    }

    @JsonProperty
    public int getBufferSize() {
        return this.bufferSize;
    }

    @JsonProperty
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @JsonProperty
    public List<String> getIoRegistries() {
        return this.ioRegistries;
    }

    @JsonProperty
    public void setIoRegistries(List<String> ioRegistries) {
        this.ioRegistries = ioRegistries;
    }

    @JsonProperty
    public List<String> getCustomClasses() {
        return this.customClasses;
    }

    @JsonProperty
    public void setCustomClasses(List<String> customClasses) {
        this.customClasses = customClasses;
    }

    @JsonProperty
    public Optional<String> getClassResolverSupplier() {
        return this.classResolverSupplier;
    }

    @JsonProperty
    public void setClassResolverSupplier(Optional<String> classResolverSupplier) {
        this.classResolverSupplier = classResolverSupplier;
    }

    @Override
    public MessageSerializer build() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("custom", this.customClasses);
        config.put("bufferSize", Integer.toString(this.bufferSize));
        config.put("serializeResultToString", Boolean.toString(this.serializeResultToString));
        config.put("ioRegistries", this.ioRegistries);
        this.classResolverSupplier.ifPresent(crs -> config.put("classResolverSupplier", crs));
        GryoMessageSerializerV1d0 serializer = new GryoMessageSerializerV1d0();
        serializer.configure(config, null);
        return serializer;
    }
}

