/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class AddSynthInst
extends Instrument {
    private double[] overtoneRatios;
    private double[] overtoneVolumes;
    private double[][] allEnvPoints;
    private double[] envPoints = new double[]{0.0, 0.0, 0.05, 1.0, 0.15, 0.4, 0.9, 0.3, 1.0, 0.0};
    private int sampleRate;

    public AddSynthInst(int sampleRate) {
        this.sampleRate = sampleRate;
        double[][] tempPoints = new double[5][];
        for (int i = 0; i < 5; ++i) {
            tempPoints[i] = this.envPoints;
        }
        this.allEnvPoints = tempPoints;
        double[] temp1 = new double[]{1.0, 3.0, 5.0, 7.0, 9.0};
        this.overtoneRatios = temp1;
        double[] temp2 = new double[]{1.0, 0.5, 0.35f, 0.25, 0.15f};
        this.overtoneVolumes = temp2;
    }

    public AddSynthInst(int sampleRate, double[] overtoneRatios, double[] overtoneVolumes, double[][] envPointArray) {
        this.overtoneRatios = overtoneRatios;
        this.overtoneVolumes = overtoneVolumes;
        this.allEnvPoints = envPointArray;
        this.sampleRate = sampleRate;
    }

    public void createChain() {
        Envelope[] env = new Envelope[this.overtoneRatios.length];
        AudioObject[] vol = new Volume[this.overtoneRatios.length];
        Oscillator[] osc = new Oscillator[this.overtoneRatios.length];
        for (int i = 0; i < this.overtoneRatios.length; ++i) {
            osc[i] = new Oscillator(this, 0, this.sampleRate, 2);
            osc[i].setFrqRatio((float)this.overtoneRatios[i]);
            env[i] = new Envelope((AudioObject)osc[i], this.allEnvPoints[i]);
            vol[i] = new Volume((AudioObject)env[i], (float)this.overtoneVolumes[i]);
        }
        Add add = new Add(vol);
        StereoPan span = new StereoPan(add);
        SampleOut sout = new SampleOut(span);
    }
}

