/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class BandPassFilterInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;

    public BandPassFilterInst(int sampleRate) {
        this(sampleRate, 2500, 1);
    }

    public BandPassFilterInst(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, 1);
    }

    public BandPassFilterInst(int sampleRate, int filterCutoff, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = channels;
    }

    public void createChain() {
        Oscillator osc = new Oscillator(this, 4, this.sampleRate, this.channels);
        Filter lpf = new Filter(osc, (double)this.filterCutoff, 0);
        Filter hpf = new Filter(lpf, (double)this.filterCutoff, 1);
        Volume vol = new Volume(hpf);
        Envelope env = new Envelope((AudioObject)vol, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0});
        StereoPan span = new StereoPan(env);
        SampleOut sout = new SampleOut(span);
    }
}

