/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Value;

public final class ControlledHPFInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;
    private int modAmount;

    public ControlledHPFInst(int sampleRate) {
        this(sampleRate, (int)((double)sampleRate * 0.2));
    }

    public ControlledHPFInst(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, (int)((double)filterCutoff * 0.6));
    }

    public ControlledHPFInst(int sampleRate, int filterCutoff, int modAmount) {
        this(sampleRate, filterCutoff, modAmount, 1);
    }

    public ControlledHPFInst(int sampleRate, int filterCutoff, int modAmount, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.modAmount = modAmount;
        this.channels = channels;
    }

    public void createChain() {
        Oscillator osc = new Oscillator(this, 3, this.sampleRate, this.channels);
        Value modfreq = new Value((Instrument)this, this.sampleRate, this.channels, 0.1f);
        Oscillator sineMod = new Oscillator(modfreq, 0, 1);
        sineMod.setAmp(this.modAmount);
        Filter filt = new Filter(new AudioObject[]{osc, sineMod}, (double)this.filterCutoff, 1);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.1, 1.0, 0.3, 0.6, 0.8, 0.2, 1.0, 0.0});
        SampleOut sout = new SampleOut(env);
    }
}

