/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Multiply;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Value;

public final class DynamicFilterInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;
    private double dynScale;

    public DynamicFilterInst(int sampleRate) {
        this(sampleRate, 200);
    }

    public DynamicFilterInst(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, 300.0, 1);
    }

    public DynamicFilterInst(int sampleRate, int filterCutoff, double dynScale) {
        this(sampleRate, filterCutoff, dynScale, 1);
    }

    public DynamicFilterInst(int sampleRate, int filterCutoff, double dynScale, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.dynScale = dynScale;
        this.channels = channels;
    }

    public void createChain() {
        Value modSource = new Value((Instrument)this, this.sampleRate, 1, 2);
        Value modAmount = new Value((Instrument)this, this.sampleRate, 1, (float)this.dynScale);
        Multiply filterControl = new Multiply(new AudioObject[]{modSource, modAmount});
        Oscillator wave = new Oscillator(this, 4, this.sampleRate, this.channels);
        Filter filt = new Filter(new AudioObject[]{wave, filterControl}, (double)this.filterCutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0});
        SampleOut sout = new SampleOut(env);
    }
}

