/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Noise;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public class FractalInst
extends Instrument {
    private EnvPoint[] pointArray = new EnvPoint[10];
    private int channels;
    private int sampleRate;
    private int resolution;

    public FractalInst(int sampleRate) {
        this(sampleRate, 1);
    }

    public FractalInst(int sampleRate, int channels) {
        this(sampleRate, channels, 1);
    }

    public FractalInst(int sampleRate, int channels, int res) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.resolution = res;
        EnvPoint[] tempArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.05f, 1.0f), new EnvPoint(0.15f, 0.4f), new EnvPoint(0.9f, 0.3f), new EnvPoint(1.0f, 0.0f)};
        this.pointArray = tempArray;
    }

    public void createChain() {
        Noise noise = new Noise((Instrument)this, 4, this.sampleRate);
        Envelope env = new Envelope((AudioObject)noise, this.pointArray);
        Volume vol = new Volume((AudioObject)env, 1.0f);
        StereoPan span = new StereoPan(vol);
        SampleOut sout = new SampleOut(span);
    }
}

