/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.RTIn;
import jm.audio.io.SampleIn;
import jm.audio.io.SampleOut;
import jm.audio.synth.Granulator;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class GranularInst
extends Instrument {
    public static final int SINE_WAVE = 0;
    public static final int COSINE_WAVE = 1;
    public static final int TRIANGLE_WAVE = 2;
    public static final int SQUARE_WAVE = 3;
    public static final int SAWTOOTH_WAVE = 4;
    public static final int SAWDOWN_WAVE = 5;
    public static final int SABERSAW_WAVE = 6;
    public static final int MICROPHONE = 13;
    private String fileName;
    private int numOfChannels;
    private float[] envelopeArray;
    private float[] durationArray;
    private float[] gpsArray;
    private float[] freqArray;
    private boolean premapped = false;
    private boolean ri = false;
    private boolean rgd = false;
    private boolean rf = false;
    private Granulator grain;
    private Volume vol;
    private StereoPan pan;
    private int sounds;

    public GranularInst(String fileName) {
        this.fileName = fileName;
        this.numOfChannels = 2;
        this.sounds = 7;
    }

    public GranularInst(int sounds) {
        this.sounds = sounds;
        this.numOfChannels = 2;
        this.fileName = "song1.au";
    }

    public GranularInst(int sounds, float[] durArr, float[] gpsArr, float[] freqArr) {
        this.sounds = sounds;
        this.durationArray = durArr;
        this.gpsArray = gpsArr;
        this.freqArray = freqArr;
        this.numOfChannels = 2;
        this.fileName = "song1.au";
        this.premapped = true;
    }

    public void createChain() {
        if (this.sounds < 0 || this.sounds > 6) {
            if (this.sounds > 10) {
                RTIn grin = new RTIn(this, 44100, 2, 8820);
                this.grain = new Granulator(grin, 44100, 2, 50, 100);
                this.vol = new Volume((AudioObject)this.grain, 0.5f);
                Volume vol2 = new Volume((AudioObject)this.vol, 0.1f);
                this.pan = new StereoPan(vol2);
                SampleOut sout = new SampleOut(this.pan);
            } else {
                SampleIn grin = new SampleIn(this, this.fileName);
                this.grain = new Granulator(grin, 44100, 2, 50, 100);
                this.vol = new Volume((AudioObject)this.grain, 0.5f);
                Volume vol2 = new Volume((AudioObject)this.vol, 0.1f);
                this.pan = new StereoPan(vol2);
                SampleOut sout = new SampleOut(this.pan);
            }
        } else {
            Oscillator grin = new Oscillator(this, this.sounds, 44100, 2);
            this.grain = new Granulator(grin, 44100, 2, 50, 100);
            this.vol = new Volume((AudioObject)this.grain, 0.5f);
            Volume vol2 = new Volume((AudioObject)this.vol, 0.1f);
            this.pan = new StereoPan(vol2);
            SampleOut sampleOut = new SampleOut(this.pan);
        }
    }
}

