/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.RTIn;
import jm.audio.io.SampleIn;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Granulator;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class GranularInstRT
extends Instrument {
    private String fileName;
    private int channels;
    private int sampleRate;
    private EnvPoint[] pointArray = new EnvPoint[10];
    private Granulator grain;
    private Volume vol;
    private StereoPan pan;
    private int sounds;

    public GranularInstRT(String fileName) {
        this.fileName = fileName;
        this.sounds = 7;
    }

    public GranularInstRT(String fileName, int sampleRate, int channels) {
        this.fileName = fileName;
        this.sounds = 7;
        this.sampleRate = sampleRate;
        this.channels = channels;
    }

    public GranularInstRT(int sounds) {
        this.sounds = sounds;
        this.fileName = "song1.au";
    }

    public GranularInstRT(int sounds, int sampleRate, int channels) {
        this.sounds = sounds;
        this.fileName = "song1.au";
        this.sampleRate = sampleRate;
        this.channels = channels;
    }

    public void createChain() {
        if (this.sounds < 0 || this.sounds > 6) {
            if (this.sounds > 10) {
                RTIn grin = new RTIn(this, this.sampleRate, this.channels, 8820);
                this.grain = new Granulator(grin, this.sampleRate, this.channels, 50, 100);
                this.vol = new Volume((AudioObject)this.grain, 0.95f);
                this.pan = new StereoPan(this.vol);
            } else {
                SampleIn grin = new SampleIn(this, this.fileName);
                this.grain = new Granulator(grin, this.sampleRate, this.channels, 50, 100);
                this.vol = new Volume((AudioObject)this.grain, 0.95f);
                this.pan = new StereoPan(this.vol);
            }
        } else {
            Oscillator grin = new Oscillator(this, this.sounds, this.sampleRate, this.channels);
            this.grain = new Granulator(grin, this.sampleRate, this.channels, 50, 100);
            this.vol = new Volume((AudioObject)this.grain, 0.95f);
            this.pan = new StereoPan(this.vol);
        }
    }

    public void setGrainsPerSecond(int sp) {
        this.grain.setGrainsPerSecond(sp);
    }

    public void setGrainDuration(int gdur) {
        this.grain.setGrainDuration(gdur);
    }

    public void setEnvelopeType(int et) {
        this.grain.setEnvelopeType(et);
    }

    public void setFreqMod(float fmod) {
        this.grain.setFreqMod(fmod);
    }

    public void setRandomIndex(boolean b) {
        this.grain.setRandomIndex(b);
    }

    public void setRandomGrainDuration(boolean b) {
        this.grain.setRandomGrainDuration(b);
    }

    public void setRandomGrainTop(int top) {
        this.grain.setRandomGrainTop(top);
    }

    public void setRandomGrainBottom(int b) {
        this.grain.setRandomGrainBottom(b);
    }

    public void setRandomFreq(boolean bool) {
        this.grain.setRandomFreq(bool);
    }

    public void setRandomDist(int rdist) {
        this.grain.setRandomDist(rdist);
    }

    public void setRandomFreqBottom(float fbot) {
        this.grain.setRandomFreqBottom(fbot);
    }

    public void setRandomFreqTop(float ftop) {
        this.grain.setRandomFreqTop(ftop);
    }

    public void setVolume(float d) {
        this.vol.setVolume(d);
    }

    public void setPan(float p) {
        this.pan.setPan(p);
    }
}

