/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class HarmonicsInst
extends Instrument {
    private static int count = 0;
    private float[] frequencies;
    private float[] volumes;
    private float pan;
    private int sampleRate;
    private Oscillator[] wt;
    private Envelope[] env;
    private Volume[] vol;
    private StereoPan[] span;
    private boolean header = true;
    private SampleOut sout;
    private int numberOfOvertones = 16;
    private EnvPoint[] pointArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.05f, 1.0f), new EnvPoint(0.15f, 0.4f), new EnvPoint(0.9f, 0.3f), new EnvPoint(1.0f, 0.0f)};

    public HarmonicsInst(int sampleRate) {
        this.sampleRate = sampleRate;
        this.frequencies = new float[this.numberOfOvertones];
        this.volumes = new float[this.numberOfOvertones];
    }

    public HarmonicsInst(int sampleRate, int numbOfOvertones) {
        this.sampleRate = sampleRate;
        this.numberOfOvertones = numbOfOvertones;
        this.frequencies = new float[this.numberOfOvertones];
        this.volumes = new float[this.numberOfOvertones];
    }

    public void createChain() {
        this.env = new Envelope[this.frequencies.length];
        this.vol = new Volume[this.frequencies.length];
        this.span = new StereoPan[this.frequencies.length];
        this.wt = new Oscillator[this.frequencies.length];
        for (int i = 0; i < this.numberOfOvertones; ++i) {
            this.wt[i] = new Oscillator(this, 0, this.sampleRate, 2);
            this.wt[i].setFrqRatio((float)i + 1.0f);
            this.env[i] = new Envelope((AudioObject)this.wt[i], this.pointArray);
            this.vol[i] = new Volume((AudioObject)this.env[i], (float)(1.0 / (double)(i + 1) * 1.5));
            this.span[i] = new StereoPan((AudioObject)this.vol[i], this.pan);
        }
        Add add = new Add(this.span);
        SampleOut sout = new SampleOut(add);
    }
}

