/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class OddEvenInst
extends Instrument {
    private static int count = 0;
    private float[] frequencies;
    private float[] volumes;
    private float pan;
    private int sampleRate;
    private Oscillator[] wt;
    private Envelope[] env;
    private Volume[] vol;
    private StereoPan[] span;
    private boolean header = true;
    private SampleOut sout;
    private int numberOfOvertones = 16;
    private EnvPoint[] pointArray0 = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.1f, 1.0f), new EnvPoint(0.4f, 0.6f), new EnvPoint(0.9f, 0.3f), new EnvPoint(1.0f, 0.0f)};
    private EnvPoint[] pointArray1 = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.1f, 1.0f), new EnvPoint(0.9f, 0.1f), new EnvPoint(1.0f, 0.0f)};
    private EnvPoint[] pointArray2 = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.1f, 0.1f), new EnvPoint(0.9f, 1.0f), new EnvPoint(1.0f, 0.0f)};

    public OddEvenInst(int sampleRate) {
        this.sampleRate = sampleRate;
        this.frequencies = new float[this.numberOfOvertones];
        this.volumes = new float[this.numberOfOvertones];
    }

    public OddEvenInst(int sampleRate, int numbOfOvertones) {
        this.sampleRate = sampleRate;
        this.numberOfOvertones = numbOfOvertones;
        this.frequencies = new float[this.numberOfOvertones];
        this.volumes = new float[this.numberOfOvertones];
    }

    public void createChain() {
        this.env = new Envelope[this.frequencies.length];
        this.vol = new Volume[this.frequencies.length];
        this.span = new StereoPan[this.frequencies.length];
        this.wt = new Oscillator[this.frequencies.length];
        for (int i = 0; i < this.numberOfOvertones; ++i) {
            this.wt[i] = new Oscillator(this, 0, this.sampleRate, 2);
            this.wt[i].setFrqRatio((float)i + 1.0f);
            if (i == 0) {
                this.env[i] = new Envelope((AudioObject)this.wt[i], this.pointArray0);
            }
            if (i % 2 == 0 && i != 0) {
                this.env[i] = new Envelope((AudioObject)this.wt[i], this.pointArray1);
            } else if (i != 0) {
                this.env[i] = new Envelope((AudioObject)this.wt[i], this.pointArray2);
            }
            this.vol[i] = new Volume((AudioObject)this.env[i], (float)(1.0 / (double)(i + 1) * 1.5));
            this.span[i] = new StereoPan((AudioObject)this.vol[i], this.pan);
        }
        Add add = new Add(this.span);
        SampleOut sout = new SampleOut(add);
    }
}

