/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;
import jm.audio.synth.WaveTable;

public final class RTSimpleFMInst
extends Instrument {
    public SampleOut sout;
    private WaveTable wt1;
    private WaveTable wt2;
    private Envelope env;
    private Add add;
    private Volume vol;
    private float pan;
    private EnvPoint[] pointArray = new EnvPoint[10];
    private int channels;
    private int dIndex;
    private float frqRatio;
    private int sampleRate;

    public RTSimpleFMInst(int sampleRate, int dIndex, double ratio) {
        this(sampleRate, 1, dIndex, ratio);
    }

    public RTSimpleFMInst(int sampleRate, int channels, int dIndex, double ratio) {
        this.sampleRate = sampleRate;
        EnvPoint[] tempArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.1f, 1.0f), new EnvPoint(0.15f, 0.4f), new EnvPoint(0.9f, 0.3f), new EnvPoint(1.0f, 0.0f)};
        this.pointArray = tempArray;
        this.channels = channels;
        this.dIndex = dIndex;
        this.frqRatio = (float)ratio;
    }

    public void setController(double[] index) {
        if (this.wt1 == null) {
            return;
        }
        this.wt1.setAmp((float)index[0]);
    }

    public void createChain() throws AOException {
        Oscillator osc = new Oscillator(this, 0, this.sampleRate, this.channels);
        osc.setAmp(this.dIndex);
        osc.setFrqRatio(this.frqRatio);
        Value cf = new Value((Instrument)this, this.sampleRate, this.channels, 1);
        AudioObject[] grp1 = new AudioObject[]{cf, this.wt1};
        Add add = new Add(grp1);
        Oscillator osc2 = new Oscillator(add, 0, 1);
        Envelope env = new Envelope((AudioObject)osc2, this.pointArray);
        Volume vol = new Volume((AudioObject)env, 1.0f);
        StereoPan span = new StereoPan(vol);
    }
}

