/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Splitter;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class ResSawInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;

    public ResSawInst(int sampleRate) {
        this(sampleRate, 2500, 1);
    }

    public ResSawInst(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, 1);
    }

    public ResSawInst(int sampleRate, int filterCutoff, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = channels;
    }

    public void createChain() {
        Value modfreq = new Value((Instrument)this, this.sampleRate, this.channels, 0.5f);
        Oscillator sineMod = new Oscillator(modfreq, 1, 1);
        Splitter lfo = new Splitter(sineMod);
        sineMod.setAmp(2000.0f);
        Oscillator wt = new Oscillator(this, 4, this.sampleRate, this.channels);
        Filter filt = new Filter(new AudioObject[]{wt, lfo}, (double)this.filterCutoff, 0);
        Filter filt2 = new Filter(new AudioObject[]{filt, lfo}, (double)this.filterCutoff, 1);
        Volume vol2 = new Volume((AudioObject)filt2, 10.0f);
        Oscillator wt3 = new Oscillator(this, 4, this.sampleRate, this.channels);
        Filter filt3 = new Filter(new AudioObject[]{wt3, lfo}, (double)this.filterCutoff, 0);
        Volume vol3 = new Volume(filt3);
        Add add = new Add(new AudioObject[]{vol2, vol3});
        Envelope env = new Envelope((AudioObject)add, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0});
        StereoPan span = new StereoPan(env);
        SampleOut sout = new SampleOut(span);
    }
}

