/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Comb;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SawCombInst
extends Instrument {
    private int sampleRate;
    private int delay;
    private double decay;
    private int channels;

    public SawCombInst(int sampleRate) {
        this(sampleRate, 300, 0.5);
    }

    public SawCombInst(int sampleRate, int delay) {
        this(sampleRate, delay, 0.5);
    }

    public SawCombInst(int sampleRate, int delay, double decay) {
        this(sampleRate, delay, decay, 2);
    }

    public SawCombInst(int sampleRate, int delay, double decay, int channels) {
        this.sampleRate = sampleRate;
        this.delay = delay;
        this.decay = decay;
        this.channels = channels;
    }

    public void createChain() {
        Oscillator wt = new Oscillator(this, 4, this.sampleRate, this.channels);
        Comb filt = new Comb(wt, this.delay, this.decay);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0});
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
        SampleOut sout = new SampleOut(span);
    }
}

