/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.ADSR;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public class SawLPFInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;

    public SawLPFInst(int sampleRate) {
        this(sampleRate, 1000);
    }

    public SawLPFInst(int sampleRate, int filterCutoff) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = 1;
    }

    public SawLPFInst(int sampleRate, int filterCutoff, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = channels;
    }

    public void createChain() {
        Oscillator osc = new Oscillator(this, 4, this.sampleRate, this.channels);
        Filter filt = new Filter(osc, (double)this.filterCutoff, 0);
        ADSR env = new ADSR(filt, 20, 100, 0.6, 400);
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
        SampleOut sout = new SampleOut(span);
    }
}

