/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Compressor;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Multiply;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class SawLPFInstF
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels;

    public SawLPFInstF(int sampleRate) {
        this(sampleRate, 1000, 1);
    }

    public SawLPFInstF(int sampleRate, int filterCutoff) {
        this(sampleRate, filterCutoff, 1);
    }

    public SawLPFInstF(int sampleRate, int filterCutoff, int channels) {
        this.sampleRate = sampleRate;
        this.filterCutoff = filterCutoff;
        this.channels = channels;
    }

    public void createChain() {
        Envelope filtEnv = new Envelope((Instrument)this, this.sampleRate, this.channels, new double[]{0.0, 0.0, 0.5, 1.0, 1.0, 0.0});
        Value scalefactor = new Value((Instrument)this, this.sampleRate, this.channels, 2000.0f);
        Multiply mult = new Multiply(new AudioObject[]{filtEnv, scalefactor});
        Oscillator wave = new Oscillator(this, 4, this.sampleRate, this.channels);
        Oscillator wave2 = new Oscillator(this, 4, this.sampleRate, this.channels);
        wave2.setFrqRatio(1.001f);
        Add summedWaves = new Add(new AudioObject[]{wave, wave2});
        Filter filt = new Filter(new AudioObject[]{summedWaves, mult}, (double)this.filterCutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 0.8, 0.3, 1.0, 0.0});
        Volume vol = new Volume(env);
        Compressor comp = new Compressor(vol);
        SampleOut sout = new SampleOut(comp);
    }
}

