/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class SimpleFMInst
extends Instrument {
    private int channels;
    private int modIndex;
    private float frqRatio;
    private int sampleRate;

    public SimpleFMInst(int sampleRate, int modIndex, double ratio) {
        this(sampleRate, modIndex, ratio, 1);
    }

    public SimpleFMInst(int sampleRate, int modIndex, double ratio, int channels) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.modIndex = modIndex;
        this.frqRatio = (float)ratio;
    }

    public void createChain() throws AOException {
        Oscillator modulator = new Oscillator(this, 0, this.sampleRate, this.channels);
        modulator.setFrqRatio(this.frqRatio);
        modulator.setAmp(this.modIndex);
        Envelope env = new Envelope((AudioObject)modulator, new double[]{0.0, 1.0, 1.0, 0.0});
        Value constFreq = new Value((Instrument)this, this.sampleRate, this.channels, 1);
        Add add = new Add(new AudioObject[]{constFreq, env});
        Oscillator carrier = new Oscillator(add, 0, 1);
        Envelope ampEnv = new Envelope((AudioObject)carrier, new double[]{0.0, 0.0, 0.02, 1.0, 1.0, 0.0});
        Volume amp = new Volume(ampEnv);
        StereoPan pan = new StereoPan(amp);
        SampleOut sout = new SampleOut(pan);
    }
}

