/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class SimpleFMInstRT
extends Instrument {
    private int channels;
    private int modIndex;
    private float frqRatio;
    private int sampleRate;

    public SimpleFMInstRT(int sampleRate, int modIndex, double ratio) {
        this(sampleRate, 1, modIndex, ratio);
    }

    public SimpleFMInstRT(int sampleRate, int channels, int modIndex, double ratio) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.modIndex = modIndex;
        this.frqRatio = (float)ratio;
    }

    public void createChain() throws AOException {
        Oscillator modulator = new Oscillator(this, 0, this.sampleRate, this.channels);
        modulator.setAmp(this.modIndex);
        modulator.setFrqRatio(this.frqRatio);
        Envelope modEnv = new Envelope((AudioObject)modulator, new double[]{0.0, 0.0, 0.2, 1.0, 1.0, 1.0});
        Volume modVol = new Volume(modEnv);
        Value offsetFrequency = new Value((Instrument)this, this.sampleRate, this.channels, 1);
        AudioObject[] grp1 = new AudioObject[]{modVol, offsetFrequency};
        Add add = new Add(grp1);
        Oscillator carrier = new Oscillator(add, 0, 1);
        Envelope env = new Envelope((AudioObject)carrier, new double[]{0.0, 0.0, 0.5, 1.0, 1.0, 0.0});
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
    }
}

