/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleIn;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Comb;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.ReSample;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SimpleReverbInst
extends Instrument {
    private String fileName;
    private int numOfChannels;
    private double baseFreq;
    private boolean wholeFile;
    private EnvPoint[] pointArray = new EnvPoint[10];

    public SimpleReverbInst(String fileName) {
        this(fileName, 440.0);
    }

    public SimpleReverbInst(String fileName, double baseFreq) {
        this(fileName, baseFreq, false);
    }

    public SimpleReverbInst(String fileName, double baseFreq, boolean wholeFile) {
        this.fileName = fileName;
        this.baseFreq = baseFreq;
        this.wholeFile = wholeFile;
        EnvPoint[] tempArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.1f, 1.0f), new EnvPoint(0.4f, 0.5f), new EnvPoint(0.95f, 0.4f), new EnvPoint(1.0f, 0.0f)};
        this.pointArray = tempArray;
    }

    public void createChain() {
        SampleIn sin = new SampleIn(this, this.fileName);
        SampleIn sin2 = new SampleIn(this, this.fileName);
        SampleIn sin3 = new SampleIn(this, this.fileName);
        SampleIn sin4 = new SampleIn(this, this.fileName);
        Comb comb = new Comb(sin, 20, 0.5);
        Comb comb2 = new Comb(sin2, 100, 0.4);
        Comb comb3 = new Comb(sin3, 70, 0.6);
        Comb comb4 = new Comb(sin4, 50, 0.5);
        AudioObject[] array = new AudioObject[]{comb, comb2, comb3, comb4};
        Add add = new Add(array);
        Filter filter = new Filter(add, 2000.0, 0);
        Filter filter2 = new Filter(filter, 2000.0, 1);
        ReSample reSample = new ReSample((AudioObject)filter2, this.baseFreq);
        Volume vol = new Volume(reSample);
        Envelope env = new Envelope((AudioObject)vol, this.pointArray);
        StereoPan span = new StereoPan(env);
        SampleOut sout = new SampleOut(span);
    }
}

