/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SineInst
extends Instrument {
    private int channels;
    private int sampleRate;
    private float frequency = -1.0f;
    private double[] envPoints;
    private SampleOut sout;

    public SineInst() {
        this(44100, 2);
    }

    public SineInst(int sampleRate) {
        this(sampleRate, 2);
    }

    public SineInst(int sampleRate, int channels) {
        this(sampleRate, channels, new double[]{0.0, 0.0, 0.15, 1.0, 0.3, 0.5, 1.0, 0.0});
    }

    public SineInst(int sampleRate, int channels, double[] points) {
        this(sampleRate, channels, points, -1.0f);
    }

    public SineInst(int sampleRate, int channels, double[] points, float frequency) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.frequency = frequency;
        this.envPoints = points;
    }

    public void setFrequency(float freq) {
        this.frequency = freq;
    }

    public void setEnvPoints(double[] newValues) {
        this.envPoints = newValues;
    }

    public void createChain() {
        Oscillator osc = new Oscillator(this, 0, this.sampleRate, this.channels);
        if (this.frequency != -1.0f) {
            osc.setChoice(0);
            osc.setFrq(this.frequency);
        }
        Envelope env = new Envelope((AudioObject)osc, this.envPoints);
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
        if (this.output == 0) {
            this.sout = new SampleOut(span);
        }
    }
}

