/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SquareInst
extends Instrument {
    private double[] envArray = new double[]{0.0, 0.0, 0.02, 1.0, 0.15, 0.6, 0.95, 0.4, 1.0, 0.0};
    private int sampleRate;
    private int channels;
    private SampleOut sout;

    public SquareInst() {
        this(44100);
    }

    public SquareInst(int sampleRate) {
        this(sampleRate, 2);
    }

    public SquareInst(int sampleRate, int channels) {
        this.sampleRate = sampleRate;
        this.channels = channels;
    }

    public SquareInst(int sampleRate, int channels, double[] envArray) {
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.envArray = envArray;
    }

    public void createChain() {
        Oscillator wt = new Oscillator(this, 3, this.sampleRate, this.channels);
        Envelope env = new Envelope((AudioObject)wt, this.envArray);
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
        if (this.output == 0) {
            this.sout = new SampleOut(span);
        }
    }
}

