/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SquareLPFInst
extends Instrument {
    private EnvPoint[] pointArray = new EnvPoint[10];
    private int sampleRate;
    private int cutoff;

    public SquareLPFInst(int sampleRate) {
        this(sampleRate, 500);
    }

    public SquareLPFInst(int sampleRate, int cutoff) {
        this.sampleRate = sampleRate;
        this.cutoff = cutoff;
        EnvPoint[] tempArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.02f, 1.0f), new EnvPoint(0.15f, 0.6f), new EnvPoint(0.95f, 0.4f), new EnvPoint(1.0f, 0.0f)};
        this.pointArray = tempArray;
    }

    public void createChain() {
        Oscillator wt = new Oscillator(this, 3, this.sampleRate, 2);
        Filter filt = new Filter(wt, (double)this.cutoff, 0);
        Envelope env = new Envelope((AudioObject)filt, this.pointArray);
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
        SampleOut sout = new SampleOut(span);
    }
}

