/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleIn;
import jm.audio.io.SampleOut;
import jm.audio.synth.ADSR;
import jm.audio.synth.Add;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.ReSample;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SubtractiveSampleInst
extends Instrument {
    private String fileName;
    private int numOfChannels;
    private double baseFreq;
    private boolean wholeFile;
    private double sustain;
    private int cutoff;
    private int attack;
    private int decay;
    private int release;
    private double modAmount = 0.9;
    private double modRate = 0.05;
    private double subAmp = 0.0;

    public SubtractiveSampleInst(String fileName) {
        this(fileName, 440.0, 500);
    }

    public SubtractiveSampleInst(String fileName, double baseFreq) {
        this(fileName, baseFreq, 500);
    }

    public SubtractiveSampleInst(String fileName, double baseFreq, int cutoff) {
        this(fileName, baseFreq, cutoff, 2, 50, 0.4, 200);
    }

    public SubtractiveSampleInst(String fileName, double baseFreq, int cutoff, int attack, int decay, double sustain, int release) {
        this.fileName = fileName;
        this.baseFreq = baseFreq;
        this.cutoff = cutoff;
        this.attack = attack;
        this.decay = decay;
        this.release = release;
        this.sustain = sustain;
    }

    public void setModAmount(double val) {
        this.modAmount = val;
    }

    public void setModDepth(double val) {
        this.modAmount = val;
    }

    public void setModRate(double val) {
        this.modRate = val;
    }

    public void setWholeFile(boolean val) {
        this.wholeFile = val;
    }

    public void setSubAmp(double val) {
        this.subAmp = val;
    }

    public void createChain() {
        SampleIn sin = new SampleIn(this, this.fileName);
        sin.setWholeFile(this.wholeFile);
        ReSample reSample = new ReSample((AudioObject)sin, this.baseFreq);
        Oscillator sineMod = new Oscillator(this, 0, sin.getSampleRate(), sin.getChannels(), 1, (float)this.modRate);
        sineMod.setAmp((float)this.modAmount * (float)this.cutoff);
        Oscillator subOsc = new Oscillator(this, 3, sin.getSampleRate(), sin.getChannels());
        subOsc.setFrqRatio(0.5);
        subOsc.setAmp((float)this.subAmp);
        Add adder = new Add(new AudioObject[]{reSample, subOsc});
        Filter filt = new Filter(new AudioObject[]{adder, sineMod}, (double)this.cutoff, 0);
        ADSR env = new ADSR(filt, this.attack, this.decay, this.sustain, this.release);
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
        SampleOut sout = new SampleOut(span);
    }
}

