/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.ADSR;
import jm.audio.synth.Add;
import jm.audio.synth.Filter;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class SubtractiveSynthInst
extends Instrument {
    private int sampleRate;
    private int filterCutoff;
    private int channels = 2;
    private double[] envValues;
    private int waveform;
    private int attack;
    private int decay;
    private double sustain;
    private int release;
    private int numbOfOsc;
    private boolean subOsc;

    public SubtractiveSynthInst(int sampleRate) {
        this(sampleRate, 4);
    }

    public SubtractiveSynthInst(int sampleRate, int waveform) {
        this(sampleRate, waveform, 500);
    }

    public SubtractiveSynthInst(int sampleRate, int waveform, int filterCutoff) {
        this(sampleRate, waveform, filterCutoff, 10, 10, 0.6, 100);
    }

    public SubtractiveSynthInst(int sampleRate, int waveform, int filterCutoff, int attack, int decay, double sustain, int release) {
        this(sampleRate, waveform, filterCutoff, attack, decay, sustain, release, 1);
    }

    public SubtractiveSynthInst(int sampleRate, int waveform, int filterCutoff, int attack, int decay, double sustain, int release, int numbOfOsc) {
        this(sampleRate, waveform, filterCutoff, attack, decay, sustain, release, numbOfOsc, false);
    }

    public SubtractiveSynthInst(int sampleRate, int waveform, int filterCutoff, int attack, int decay, double sustain, int release, int numbOfOsc, boolean subOsc) {
        this.sampleRate = sampleRate;
        this.waveform = waveform;
        this.filterCutoff = filterCutoff;
        this.envValues = this.envValues;
        this.attack = attack;
        this.decay = decay;
        this.sustain = sustain;
        this.release = release;
        this.numbOfOsc = numbOfOsc;
        this.subOsc = subOsc;
    }

    public void createChain() {
        Value[] modFrequency = new Value[this.numbOfOsc];
        Oscillator[] modulator = new Oscillator[this.numbOfOsc];
        Oscillator[] oscArray = new Oscillator[this.numbOfOsc];
        Value[] constFreq = new Value[this.numbOfOsc];
        Add[] add = new Add[this.numbOfOsc];
        AudioObject[] volArray = new Volume[this.numbOfOsc];
        for (int i = 0; i < this.numbOfOsc; ++i) {
            modFrequency[i] = new Value((Instrument)this, this.sampleRate, this.channels, (float)(Math.random() * 0.2));
            modulator[i] = new Oscillator(modFrequency[i], 0, 1);
            modulator[i].setAmp(0.3f);
            constFreq[i] = new Value((Instrument)this, this.sampleRate, this.channels, 1);
            add[i] = new Add(new AudioObject[]{constFreq[i], modulator[i]});
            oscArray[i] = new Oscillator(add[i], this.waveform, 1);
            if (i % 2 == 0 && i > 0) {
                oscArray[i].setFrqRatio((float)(1.0 + 0.001 * (double)(i - 1)));
            } else if (this.subOsc && i == 1) {
                oscArray[i].setFrqRatio((float)(0.5 - 0.001 * (double)i));
            } else {
                oscArray[i].setFrqRatio((float)(1.0 - 0.001 * (double)i));
            }
            volArray[i] = i == 0 ? new Volume((AudioObject)oscArray[i], 1.0) : new Volume((AudioObject)oscArray[i], 0.3);
        }
        Add add2 = new Add(volArray);
        Filter filt = new Filter(add2, (double)this.filterCutoff, 0);
        ADSR env = new ADSR(filt, this.attack, this.decay, this.sustain, this.release);
        Volume vol = new Volume(env);
        StereoPan pan = new StereoPan(vol);
        SampleOut sout = new SampleOut(pan);
    }
}

