/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.EnvPoint;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class SuperSawInst
extends Instrument {
    private EnvPoint[] pointArray = new EnvPoint[10];
    private int sampleRate;
    private double detune;

    public SuperSawInst(int sampleRate) {
        this(sampleRate, 0.001);
    }

    public SuperSawInst(int sampleRate, double detune) {
        this.sampleRate = sampleRate;
        this.detune = detune;
        EnvPoint[] tempArray = new EnvPoint[]{new EnvPoint(0.0f, 0.0f), new EnvPoint(0.02f, 1.0f), new EnvPoint(0.15f, 0.6f), new EnvPoint(0.9f, 0.3f), new EnvPoint(1.0f, 0.0f)};
        this.pointArray = tempArray;
    }

    public void createChain() {
        Oscillator wt1 = new Oscillator(this, 4, this.sampleRate, 2);
        Oscillator wt2 = new Oscillator(this, 4, this.sampleRate, 2);
        wt2.setFrqRatio((float)(1.0 + this.detune));
        Oscillator wt3 = new Oscillator(this, 4, this.sampleRate, 2);
        wt3.setFrqRatio((float)(1.0 - this.detune * 2.0));
        Oscillator wt4 = new Oscillator(this, 4, this.sampleRate, 2);
        wt4.setFrqRatio((float)(1.0 + this.detune * 2.0));
        Oscillator wt5 = new Oscillator(this, 4, this.sampleRate, 2);
        wt5.setFrqRatio((float)(1.0 - this.detune));
        Oscillator wt6 = new Oscillator(this, 4, this.sampleRate, 2);
        wt6.setFrqRatio((float)(1.0 + this.detune * 3.0));
        Oscillator wt7 = new Oscillator(this, 4, this.sampleRate, 2);
        wt7.setFrqRatio((float)(1.0 - this.detune * 3.0));
        AudioObject[] waves = new AudioObject[]{wt1, wt2, wt3, wt4, wt5, wt6, wt7};
        Add add = new Add(waves);
        Envelope env = new Envelope((AudioObject)add, this.pointArray);
        Volume vol = new Volume(env);
        StereoPan span = new StereoPan(vol);
        SampleOut sout = new SampleOut(span);
    }
}

