/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.StereoPan;
import jm.audio.synth.Volume;

public final class TimpaniInst
extends Instrument {
    private int overtones = 5;
    private double[][] points = new double[this.overtones][8];
    private double[] freqVals = new double[]{1.0, 1.42, 1.53, 1.77, 1.94};
    private double[] volVals = new double[]{1.0, 0.8, 0.7, 0.6, 0.5};
    private double[] pointArray1 = new double[]{0.0, 0.0, 0.002, 1.0, 0.3, 0.3, 1.0, 0.0};
    private double[] pointArray2 = new double[]{0.0, 0.0, 0.05, 1.0, 0.2, 0.4, 1.0, 0.0};
    private double[] pointArray3 = new double[]{0.0, 0.0, 0.1, 1.0, 0.4, 0.3, 1.0, 0.0};
    private float pan;
    private int sampleRate;
    private Oscillator[] osc;
    private Envelope[] env;
    private Volume[] vol;

    public TimpaniInst(int sampleRate) {
        this.sampleRate = sampleRate;
        this.points[0] = this.pointArray1;
        this.points[1] = this.pointArray2;
        this.points[2] = this.pointArray3;
        this.points[3] = this.pointArray2;
        this.points[4] = this.pointArray3;
    }

    public void createChain() {
        this.osc = new Oscillator[this.overtones];
        this.env = new Envelope[this.overtones];
        this.vol = new Volume[this.overtones];
        for (int i = 0; i < this.overtones; ++i) {
            this.osc[i] = new Oscillator(this, 0, this.sampleRate, 2);
            this.osc[i].setFrqRatio((float)this.freqVals[i]);
            this.env[i] = new Envelope((AudioObject)this.osc[i], this.points[i]);
            this.vol[i] = new Volume((AudioObject)this.env[i], (float)this.volVals[i]);
        }
        Add add = new Add(this.vol);
        StereoPan span = new StereoPan(add);
        SampleOut sout = new SampleOut(span);
    }
}

