/*
 * Decompiled with CFR 0.152.
 */
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.audio.synth.Add;
import jm.audio.synth.Envelope;
import jm.audio.synth.Oscillator;
import jm.audio.synth.Value;
import jm.audio.synth.Volume;

public final class VibratoInst
extends Instrument {
    private int channels;
    private int modIndex;
    private float frqRatio;
    private int sampleRate;

    public VibratoInst(int sampleRate) {
        this(sampleRate, 1);
    }

    public VibratoInst(int sampleRate, int channels) {
        this.sampleRate = sampleRate;
        this.channels = channels;
    }

    public void createChain() throws AOException {
        Oscillator modulator = new Oscillator(this, 0, this.sampleRate, this.channels, 1, 5.0);
        modulator.setAmp(8.0f);
        Value constFreq = new Value((Instrument)this, this.sampleRate, this.channels, 1);
        Add add = new Add(new AudioObject[]{constFreq, modulator});
        Oscillator carrier = new Oscillator(add, 0, 1);
        Envelope env2 = new Envelope((AudioObject)carrier, new double[]{0.0, 0.0, 0.1, 1.0, 1.0, 0.0});
        Volume amp = new Volume(env2);
        SampleOut sout = new SampleOut(amp);
    }
}

