/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Stack;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public final class Audio
implements JMC {
    private static boolean JPF = false;
    private static int channels;
    private static int sampleRate;

    public static void processScore(Score score, Instrument[] instList, String fileName) {
        Stack<Instrument> inst = new Stack<Instrument>();
        inst.push(instList[0]);
        for (int i = 0; i < instList.length; ++i) {
            if (instList[i] == null || instList[i].getInitialised()) continue;
            try {
                if (instList[i].getInitialised()) continue;
                instList[i].createChain();
                instList[i].setInitialised(true);
                continue;
            }
            catch (AOException e) {
                e.printStackTrace();
            }
        }
        Enumeration enum1 = score.getPartList().elements();
        double score_ratio = 60.0 / score.getTempo();
        int partCounter = 0;
        while (enum1.hasMoreElements()) {
            Part part = (Part)enum1.nextElement();
            double part_ratio = score_ratio;
            if (part.getTempo() > 0.0) {
                part_ratio = 60.0 / part.getTempo();
            }
            if (part.getInstrument() != -1) {
                try {
                    inst.push(instList[part.getInstrument()]);
                }
                catch (ArrayIndexOutOfBoundsException npe) {
                    System.out.println("jMusic Audio warning: Can't find the instrument number " + part.getInstrument() + " that you have specified for " + "the part named " + part.getTitle() + ".");
                }
            }
            System.out.println("Part " + partCounter++ + " '" + part.getTitle() + "'. ");
            Enumeration enum2 = part.getPhraseList().elements();
            int phraseCounter = 0;
            while (enum2.hasMoreElements()) {
                Phrase phr = (Phrase)enum2.nextElement();
                double phrase_ratio = part_ratio;
                if (phr.getTempo() > 0.0) {
                    System.out.println("A: " + phrase_ratio);
                    phrase_ratio = 60.0 / phr.getTempo();
                    System.out.println("B: " + phrase_ratio);
                }
                if (phr.getInstrument() != -1) {
                    try {
                        inst.push(instList[phr.getInstrument()]);
                    }
                    catch (ArrayIndexOutOfBoundsException npe) {
                        System.out.println("jMusic Audio warning: Can't find the instrument number " + phr.getInstrument() + " that you have specified for" + " the phrase named " + phr.getTitle() + ".");
                    }
                }
                double time = part_ratio * phr.getStartTime();
                double ntime = 0.0;
                Enumeration enum3 = phr.getNoteList().elements();
                System.out.print("    Phrase " + phraseCounter++ + " '" + phr.getTitle() + "'" + " starting at beat " + phr.getStartTime() + ": ");
                int phraseNoteCounter = 0;
                while (enum3.hasMoreElements()) {
                    Note note = (Note)enum3.nextElement();
                    if (note.getFrequency() == -2.147483648E9) {
                        ntime += phrase_ratio * note.getRhythmValue();
                        continue;
                    }
                    if (++phraseNoteCounter % 10 == 0) {
                        System.out.print(phraseNoteCounter);
                    } else {
                        System.out.print(".");
                    }
                    Note new_note = note.copy();
                    new_note.setDuration(phrase_ratio * note.getDuration());
                    new_note.setRhythmValue(phrase_ratio * note.getRhythmValue());
                    Instrument currInst = (Instrument)inst.peek();
                    currInst.setBlock(false);
                    currInst.setFinished(true);
                    currInst.renderNote(new_note, time + ntime);
                    currInst.setFinished(false);
                    currInst.iterateChain();
                    ntime += phrase_ratio * note.getRhythmValue();
                }
                System.out.println();
                if (phr.getInstrument() == -1) continue;
                inst.pop();
            }
        }
    }

    public static void combine(String fileJmp, String tmpFile, String fileOut, boolean deleteFiles, boolean multi) {
        if (multi) {
            sampleRate = SampleOut.samprate;
            channels = SampleOut.numofchan;
            System.out.println("Bit Depth: 16 Sample rate: " + SampleOut.samprate + " Channels: " + SampleOut.numofchan);
            Audio.addEmUp(tmpFile, fileOut, SampleOut.max);
            return;
        }
        int numofdot = 1;
        float max = 0.0f;
        try {
            FileReader fr = new FileReader(fileJmp);
            StreamTokenizer st = new StreamTokenizer(fr);
            RandomAccessFile raf = new RandomAccessFile(tmpFile, "rw");
            double time1 = System.currentTimeMillis();
            block5: while (true) {
                try {
                    while (true) {
                        st.nextToken();
                        String fileName = st.sval;
                        if (fileName == null) break block5;
                        st.nextToken();
                        long position = (long)(st.nval * 4.0);
                        st.nextToken();
                        int length = (int)st.nval;
                        float res = Audio.getAudio(fileName, position, length, max, raf);
                        if (max < res) {
                            max = res;
                            System.out.println("Max is smaller: " + max);
                        }
                        if (res < 0.0f && max < res * -1.0f) {
                            max = res * -1.0f;
                            System.out.println("MAX is bigger: " + max);
                        }
                        if (numofdot % 10 == 0) {
                            System.out.print(numofdot);
                        } else {
                            System.out.print(".");
                        }
                        ++numofdot;
                        raf.close();
                    }
                }
                catch (EOFException eof) {
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                break;
            }
            System.out.print("\n");
            double time2 = System.currentTimeMillis();
            System.out.println("Created tmp file in " + (time2 - time1) / 1000.0 + " seconds");
            double now = System.currentTimeMillis();
            Audio.addEmUp(tmpFile, fileOut, max);
            double now2 = System.currentTimeMillis();
            System.out.println("Mixed to a single file in " + (now2 - now) / 1000.0 + " seconds");
            if (deleteFiles) {
                File jmp = new File(fileJmp);
                File tpm = new File(tmpFile);
                jmp.delete();
                tpm.delete();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static float getAudio(String fileName, long position, int length, float max, RandomAccessFile raf) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            fis = new FileInputStream(fileName);
            bis = new BufferedInputStream(fis, 4096);
            dis = new DataInputStream(bis);
            if (dis.readInt() != 779316836) {
                System.out.println("jMusic SampleIn warning: This file is NOT in the .au/.snd file format");
                return max;
            }
            int offset = dis.readInt();
            int numOfBytes = dis.readInt();
            int format = dis.readInt();
            sampleRate = dis.readInt();
            channels = dis.readInt();
            fis.skip(offset - 24);
            position *= (long)channels;
            length *= channels;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        block9: while (true) {
            try {
                while (true) {
                    raf.seek(position);
                    float sample = (float)dis.readShort() / 32767.0f;
                    try {
                        float d = raf.readFloat();
                        raf.seek(position);
                        position += 4L;
                        float tmp = d + sample;
                        if (max < tmp) {
                            max = tmp;
                            System.out.println("MAX small: " + max);
                        }
                        if (tmp < 0.0f && max < tmp * -1.0f) {
                            max = tmp * -1.0f;
                            System.out.println("MAX large: " + max);
                        }
                        raf.writeFloat(tmp);
                        continue block9;
                    }
                    catch (EOFException eofe) {
                        if (max < sample) {
                            max = sample;
                        }
                        if (sample < 0.0f && max < sample * -1.0f) {
                            max = sample * -1.0f;
                        }
                        raf.writeFloat(sample);
                        position += 4L;
                        continue;
                    }
                    break;
                }
            }
            catch (EOFException eofe) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            break;
        }
        try {
            dis.close();
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return max;
    }

    public static void addEmUp(String tmpFileName, String fileName, float max) {
        System.out.println("MAX amplitude: " + max);
        System.out.println("Writing .au/.snd file '" + fileName + "' please wait...");
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
            DataOutputStream dos = new DataOutputStream(bos);
            File tmpF = new File(tmpFileName);
            FileInputStream fin = new FileInputStream(tmpF);
            BufferedInputStream bin = new BufferedInputStream(fin, 4096);
            DataInputStream dis = new DataInputStream(bin);
            int offset = 28;
            int numOfBytes = 0;
            int format = 3;
            dos.writeInt(779316836);
            dos.writeInt(offset);
            dos.writeInt(numOfBytes);
            dos.writeInt(format);
            dos.writeInt(sampleRate);
            dos.writeInt(channels);
            dos.writeInt(0);
            double tt = System.currentTimeMillis();
            try {
                while (true) {
                    float samp;
                    float outgoing;
                    if ((outgoing = (samp = dis.readFloat()) / max) < -1.0f || outgoing > 1.0f) {
                        System.out.println("Outgoing= " + outgoing + "  SAMPLE: " + samp + "  MAX: " + max + "  SampleOut.max: " + SampleOut.max);
                    }
                    dos.writeShort((short)(outgoing * 32767.0f));
                    numOfBytes += 2;
                }
            }
            catch (EOFException eofe) {
                double ttt = System.currentTimeMillis();
                System.out.println("Finished writing the audio file in " + (ttt - tt) / 1000.0 + " seconds");
                dos.flush();
                fos.flush();
                bos.flush();
                dos.close();
                fos.close();
                bos.close();
                fin.close();
                bin.close();
                dis.close();
                tmpF.delete();
                if (tmpF.exists()) {
                    RandomAccessFile raf = new RandomAccessFile(tmpFileName, "rw");
                    raf.setLength(0L);
                    raf.close();
                }
                RandomAccessFile auxraf = new RandomAccessFile(fileName, "rw");
                auxraf.seek(8L);
                auxraf.writeInt(numOfBytes);
                auxraf.close();
                return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println(ioe);
        }
    }
}

