/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class SampleIn
extends AudioObject
implements JMC {
    private File file;
    private AudioFileFormat fileFormat;
    private AudioFormat format;
    private int sampleSize;
    private String fileType;
    private boolean cache;
    private long duration;
    private InputStream is;
    private boolean wholeFile = false;
    private int loop;
    private int loopCount;
    private int loopStart;
    private int loopEnd;
    private int streamPosition;
    private boolean bigEndian;

    public SampleIn(Instrument inst, String fileName) {
        this(inst, fileName, false);
    }

    public SampleIn(Instrument inst, String fileName, boolean cache) {
        this(inst, fileName, cache, false);
    }

    public SampleIn(Instrument inst, String fileName, boolean cache, boolean wholeFile) {
        this(inst, fileName, cache, wholeFile, 0);
    }

    public SampleIn(Instrument inst, String fileName, boolean cache, boolean wholeFile, int loop) {
        this(inst, fileName, cache, wholeFile, 0, 0, 0);
    }

    public SampleIn(Instrument inst, String fileName, boolean cache, boolean wholeFile, int loop, int loopStart, int loopEnd) {
        super(inst, 0, "[SampleIn]");
        try {
            this.file = new File(fileName);
            this.cache = cache;
            this.wholeFile = wholeFile;
            this.loop = loop;
            this.loopStart = loopStart;
            this.loopEnd = loopEnd;
            if (this.loop == -1) {
                this.loop = Integer.MAX_VALUE;
            }
            this.fileFormat = AudioSystem.getAudioFileFormat(this.file);
            this.format = this.fileFormat.getFormat();
            this.bigEndian = this.format.isBigEndian();
            this.channels = this.format.getChannels();
            this.sampleRate = (int)this.format.getSampleRate();
            this.duration = (long)this.fileFormat.getFrameLength() * (long)this.channels;
            this.sampleSize = this.format.getSampleSizeInBits() / 8;
            this.fileType = this.fileFormat.toString();
            this.is = AudioSystem.getAudioInputStream(this.file);
            if (this.cache) {
                byte[] tmp = new byte[(int)this.duration * this.sampleSize];
                this.is.read(tmp);
                this.is.close();
                this.is = new ByteArrayInputStream(tmp);
            }
        }
        catch (UnsupportedAudioFileException uafe) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void finalize() {
        try {
            this.is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void build() {
        if (!this.wholeFile) {
            this.duration = (long)(this.currentNote.getDuration() * (double)this.sampleRate * (double)this.channels);
        }
        this.loopCount = this.loop;
        this.reset(0);
    }

    public void reset(int spot) {
        this.streamPosition = 0;
        try {
            if (this.cache) {
                this.is.reset();
            } else {
                this.is = AudioSystem.getAudioInputStream(this.file);
                if (spot > 0) {
                    this.is.read(new byte[spot * this.sampleSize * this.channels]);
                }
            }
        }
        catch (UnsupportedAudioFileException uafe) {
            System.out.println("jMusic SampleIn error: This file format is not supported.");
            System.exit(0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public int work(float[] buffer) throws AOException {
        this.finished = false;
        byte[] tmp = new byte[this.sampleSize * this.channels];
        byte[] sampleTmp = new byte[this.sampleSize];
        for (int i = 0; i < buffer.length - this.channels; i += this.channels) {
            try {
                if (this.is.read(tmp) == -1) {
                    this.finished = true;
                    continue;
                }
                for (int j = 0; j < this.channels; ++j) {
                    for (int k = 0; k < this.sampleSize; ++k) {
                        sampleTmp[k] = tmp[k + j * this.sampleSize];
                    }
                    buffer[i + j] = this.getFloat(sampleTmp);
                    if (++this.streamPosition == this.loopStart && this.loop > 0) {
                        this.is.mark(this.loopStart);
                    } else if (this.streamPosition == this.loopEnd && this.loop > 0 && --this.loopCount >= 1) {
                        this.reset(this.loopStart);
                        this.streamPosition = this.loopStart;
                    }
                    if ((long)this.streamPosition < this.duration) continue;
                    this.finished = true;
                }
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return buffer.length;
    }

    public void setWholeFile(boolean val) {
        this.wholeFile = val;
    }

    public int getWaveSize() {
        return (int)(this.duration / (long)this.channels);
    }

    public int getNumOfBytes() {
        return (int)(this.duration * (long)this.sampleSize);
    }

    public int getBits() {
        return this.sampleSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getBitResolution() {
        int depth = -1;
        switch (this.sampleSize) {
            case 1: {
                depth = 8;
                break;
            }
            case 2: {
                depth = 16;
                break;
            }
            case 3: {
                depth = 24;
                break;
            }
            case 4: {
                depth = 32;
            }
        }
        return depth;
    }

    private float getFloat(byte[] b) {
        float sample = 0.0f;
        int ret = 0;
        int length = b.length;
        int i = 0;
        while (i < b.length) {
            ret |= (b[i] & 0xFF) << (this.bigEndian ? length : i + 1) * 8 - 8;
            ++i;
            --length;
        }
        switch (this.sampleSize) {
            case 1: {
                if (ret > 127) {
                    ret ^= 0xFFFFFFFF;
                    ret &= 0x7F;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 127.0f;
                break;
            }
            case 2: {
                if (ret > Short.MAX_VALUE) {
                    ret ^= 0xFFFFFFFF;
                    ret &= Short.MAX_VALUE;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 32767.0f;
                break;
            }
            case 3: {
                if (ret > 0x7FFFFF) {
                    ret ^= 0xFFFFFFFF;
                    ret &= 0x7FFFFF;
                    ret = ~ret + 1;
                }
                sample = (float)ret / 8388608.0f;
                break;
            }
            case 4: {
                sample = (float)((double)ret / 2.147483647E9);
                break;
            }
            default: {
                System.err.println("Format not accepted");
            }
        }
        return sample;
    }

    public void setLoopStart(int newPos) {
        this.loopStart = newPos;
    }

    public void setLoopEnd(int newPos) {
        this.loopEnd = newPos;
    }

    public void setLoop(int times) {
        this.loop = times;
    }
}

