/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import java.util.Vector;
import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Delay
extends AudioObject {
    Vector storedSamples = new Vector();
    int sampleDelay = 0;
    int sampleCounter = 0;

    public Delay(AudioObject ao, int sampleDelay) {
        super(ao, "[Delay]");
        this.sampleDelay = sampleDelay;
    }

    public int work(float[] buffer) throws AOException {
        int returned = this.previous[0].nextWork(buffer);
        if (this.sampleCounter >= this.sampleDelay) {
            for (int i = 0; i < returned; ++i) {
                this.storedSamples.addElement(new Float(buffer[i]));
                Float tempFloat = (Float)this.storedSamples.elementAt(this.storedSamples.size() - 1);
                buffer[i] = tempFloat.floatValue();
                this.storedSamples.removeElementAt(this.storedSamples.size() - 1);
            }
        } else {
            for (int i = 0; i < returned; ++i) {
                this.storedSamples.addElement(new Float(buffer[i]));
                buffer[i] = 0.0f;
            }
        }
        ++this.sampleCounter;
        return returned;
    }
}

